#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::Deep;
use Test::Partner2::Simple;

use Encode;
use Test::More;
use Test::Exception;

my $test_opts = {dont_create_database => 1, locale => 'en'};

run_tests(
    sub {
        my ($app) = @_;

        my $got    = $app->get_locales();
        my $expect = {
            en => {
                code   => 'en_GB.UTF-8',
                domain => 'yandex.com',
                name   => 'English'
            },
            ru => {
                code    => 'ru_RU.UTF-8',
                default => 1,
                domain  => 'yandex.ru',
                name    => decode_utf8('Русский')
            }
        };

        cmp_deeply($got, $expect, 'Correct initial database state');

    },
    %$test_opts
);
