#!/usr/bin/perl -w

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_curdate mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use PiConstants qw($ASSESSOR_ROLE_ID);
use Test::Differences;

run_tests(
    sub {
        my ($app) = @_;

        my @graphite_data;
        my @log_data;
        mock_subs(
            {
                'Utils::MonitoringUtils::send_to_graphite' => sub {
                    my (%opts) = @_;
                    push @graphite_data, \%opts;
                },
                'Cron::Methods::Assessors::INFOF' => sub {
                    my (@params) = @_;
                    push @log_data, \@params;
                },
                'Cron::Methods::Assessors::INFO' => sub {
                    my (@params) = @_;
                    push @log_data, \@params;
                },
            }
        );

        mock_curdate('2019-06-27 11:10:00');

        my @result;
        $app->partner_db->user_role->add(
            {
                user_id => 1009,
                role_id => $ASSESSOR_ROLE_ID
            }
        );

        $app->do('assessors', 'delete_old_assessor_pages');

        push @result, 'graphite_data', [@graphite_data];
        push @result, 'log_data',      [@log_data];

        @graphite_data = ();
        @log_data      = ();

        mock_curdate('2019-06-28 11:10:00');

        $app->do('assessors', 'delete_old_assessor_pages');

        push @result, 'graphite_data', [@graphite_data];
        push @result, 'log_data',      [@log_data];

        my $expected = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $expected, 'checks');
    },
    application_package => 'Cron',
    mocks               => {mock_send_to_graphite => FALSE}
);
