#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::More;
use Test::Differences;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        $app->partner_db->common_offer_allowed_users->add_multi(
            [
                {
                    user_id  => 1009,
                    deadline => '2018-12-02',
                },
                {
                    user_id  => 1016,
                    deadline => '2018-12-03',
                },
            ]
        );

        my %data;

        mock_curdate('2018-12-02 15:00:00');
        $app->do('assistants', 'check_common_offer');
        $data{'2018-12-01'} = $app->assistants->get_all();

        mock_curdate('2018-12-03 15:00:00');
        $app->do('assistants', 'check_common_offer');
        $data{'2018-12-02'} = $app->assistants->get_all();

        mock_curdate('2018-12-04 15:00:00');
        $app->do('assistants', 'check_common_offer');
        $data{'2018-12-03'} = $app->assistants->get_all();

        my $has = get_test_data_and_update_if_needed('data.json', \%data);

        eq_or_diff(from_json(to_json(\%data)), $has, 'compare data');
    },
    application_package => 'Cron',
);
