#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Differences qw(eq_or_diff);
use Test::Partner::Utils qw(mock_curdate);
use Test::Partner2::Mock qw(mock_subs restore_subs);
use Utils::Logger qw(INFO);

use qbit;

my $DATE = '2017-01-04 12:32:05';

my $TEST_DATA = [
    {
        'page_id' => 1,
        'domain'  => 'yandex.ru',
        'hits'    => 10001
    },
    {
        'page_id' => 1,
        'domain'  => 'bad_domain_small_hits',
        'hits'    => 1
    },
    {
        'page_id' => 1,
        'domain'  => 'context-bad-domain.ru',
        'hits'    => 10002
    },
    {

        'page_id' => 803,
        'domain'  => 'search-bad-domain.ru',
        'hits'    => 10003
    },
];

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate($DATE);

        restore_subs(['LWP::UserAgent::request']);

        mock_subs(
            {
                'LWP::UserAgent::request' => sub {
                    my ($self, $url, $content_file_path) = @_;

                    my $r = HTTP::Response->new(200);
                    $r->request(HTTP::Request->new());
                    $r->content('Mocked content');
                    my $content;
                    for my $line (@$TEST_DATA) {
                        $content .= sprintf("%s\t%s\t%s\n", $line->{page_id}, $line->{domain}, $line->{hits});
                    }

                    writefile($content_file_path, $content);
                    return $r;
                },
                'QBit::Application::Model::API::Yandex::HTTPGoZora::is_site_working' => sub {
                    return TRUE;
                },
            }
        );

        my $context_bad_domains = $app->partner_db->context_on_site_mirrors->get_all(
            fields => [qw(domain multistate)],
            filter => {campaign_id => 1}
        );

        eq_or_diff($context_bad_domains, [],
            'bad_domains for context_on_site_campaign should be empty before the test');

        my $search_bad_domains = $app->partner_db->search_on_site_mirrors->get_all(
            fields => [qw(domain multistate)],
            filter => {campaign_id => 803}
        );

        eq_or_diff($search_bad_domains, [], 'bad_domains for search_on_site_campaign should be empty before the test');

        $app->do('bad_domains', 'add_baddomains_moderation');

        $context_bad_domains = $app->partner_db->context_on_site_mirrors->get_all(
            fields => [qw(domain multistate)],
            filter => {campaign_id => 1}
        );

        eq_or_diff(
            $context_bad_domains,
            [{'domain' => 'context-bad-domain.ru', 'multistate' => 0}],
            'incorrect bad_domains for context_on_site_campaign'
        );

        $search_bad_domains = $app->partner_db->search_on_site_mirrors->get_all(
            fields => [qw(domain multistate)],
            filter => {campaign_id => 803}
        );

        eq_or_diff(
            $search_bad_domains,
            [{'domain' => 'search-bad-domain.ru', 'multistate' => 0}],
            'incorrect bad_domains for search_on_site_campaign'
        );
    },
    application_package => 'Cron',
    init                => [qw(api_http_gozora)]
);
