#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner::Utils qw(mock_curdate);
use Test::Partner2::Simple;

use Test::More;
use Test::Differences qw(eq_or_diff);

use qbit;

my $expect_delete = {
    'buffer_yt_to_delete' => [
        {
            'block_id' => 1,
            'page_id'  => 142898
        },
        {
            'block_id' => 100000,
            'page_id'  => 41443
        }
    ],
    'buffer_pi_to_delete' => [
        {
            'block_id' => '1',
            'page_id'  => '142898',
            'rule_id'  => '21'
        },
        {
            'block_id' => '1',
            'page_id'  => '41443',
            'rule_id'  => '16'
        },
        {
            'block_id' => '100000',
            'page_id'  => '41443',
            'rule_id'  => '10'
        }
    ],
};

my $expect_send = {
    'buffer_yt_to_update' => [
        {
            'block_id' => 1,
            'data'     => {
                'page_imp' => [{'imp_id' => 1, 'page_id' => 41443}],
                'rules'    => [
                    {
                        'context' => [
                            [['browser-name',      'equal', '2'], ['browser-name', 'equal', '88']],
                            [['device-is-desktop', 'equal', '1'], ['device-is-tv', 'equal', '1']],
                            [['puid1',  'match', 'foo'], ['puid1',  'match', 'bar'], ['puid63', 'match', 'baz']],
                            [['reg-id', 'equal', '1'],   ['reg-id', 'equal', '255']],
                            [['detailed-device-type', 'equal', '15'], ['detailed-device-type', 'equal', '33']],
                            [['referer', 'like', '%http://foo.com%'], ['referer', 'like', '%https://bar.net%']],
                        ],
                        'min_cpm' => 0.099,
                        'rule_id' => 10
                    },
                    {'context' => [], 'min_cpm' => 0, 'rule_id' => 15}
                ]
            },
            'page_id' => 41443
        }
    ],
    'buffer_pi_to_keep' => [
        {
            'block_id' => '1',
            'page_id'  => '41443',
            'rule_id'  => '10'
        },
        {
            'block_id' => '1',
            'page_id'  => '41443',
            'rule_id'  => '15'
        }
    ],

};

run_tests(
    sub {
        my ($app) = @_;

        no strict 'refs';
        no warnings 'redefine';

        my ($buffer_yt_to_delete, $buffer_pi_to_delete);
        *{'Cron::Methods::BusinessRules::_delete_from_yt'} = sub {
            (my $self, $buffer_yt_to_delete, $buffer_pi_to_delete) = @_;
            return 1;
        };

        my ($buffer_yt_to_update, $buffer_pi_to_keep);
        *{'Cron::Methods::BusinessRules::_send_to_yt'} = sub {
            (my $self, $buffer_yt_to_update, $buffer_pi_to_keep) = @_;
            return 1;
        };

        $app->do('business_rule_methods', 'async_update');

        my $data = [];
        foreach my $row (@$buffer_yt_to_update) {
            $row->{data} = from_json($row->{data});
        }

        my $got_delete = {buffer_yt_to_delete => $buffer_yt_to_delete, buffer_pi_to_delete => $buffer_pi_to_delete};
        eq_or_diff($got_delete, $expect_delete, 'delete', {context => 5});

        my $got_send = {buffer_yt_to_update => $buffer_yt_to_update, buffer_pi_to_keep => $buffer_pi_to_keep};
        eq_or_diff($got_send, $expect_send, 'send', {context => 5});

    },
    application_package => 'Cron',
);
