#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner::Utils qw(mock_curdate);
use Test::Partner2::Simple;

use Test::More;
use Test::Differences qw(eq_or_diff);
use Test::Partner2::Simple;
use Test::Partner2::Mock qw( mock_subs );

use qbit;

our $row_to_update;

my $expected_upsert_rows = [
    {
        caption     => unset_utf('Правило #99 - working (mocked-yan-partner)'),
        id          => 1,
        update_time => '1970-01-01 03:00:00'
    },
    {
        caption     => 'Rule #10 - working (mocked-yan-partner)',
        id          => 10,
        update_time => '1970-01-01 03:00:00'
    },
    {
        caption     => 'Rule #11 - working (mocked-yan-partner)',
        id          => 11,
        update_time => '1970-01-01 03:00:00'
    },
    {
        caption     => 'Rule #12 - stopped (mocked-yan-partner)',
        id          => 12,
        update_time => '1970-01-01 03:00:00'
    },
    {
        caption     => 'Rule #13 - deleted (mocked-yan-partner)',
        id          => 13,
        update_time => '1970-01-01 03:00:00'
    },
    {
        caption     => 'Rule #14 - working (mocked-yan-partner)',
        id          => 14,
        update_time => '1970-01-01 03:00:00'
    },
    {
        caption     => 'Rule #15 - working (mocked-yan-partner)',
        id          => 15,
        update_time => '1970-01-01 03:00:00'
    },
    {
        caption     => 'Rule #16 - working (mocked-yan-partner)',
        id          => 16,
        update_time => '1970-01-01 03:00:00'
    },
    {
        caption     => 'Rule #21 - deleted (mocked-context-adblock-partner)',
        id          => 21,
        update_time => '1970-01-01 03:00:00'
    },
];

run_tests(
    sub {
        my ($app) = @_;

        $app->partner_db->business_rules->add_multi(
            [
                {
                    caption     => 'Правило #99 - working (mocked-yan-partner)',
                    rule_id     => 1,
                    update_time => '1970-01-01 03:00:00'
                },
            ]
        );
        mock_subs(
            {
                'QBit::Application::Model::API::Yandex::YT::insert_rows' => sub {
                    my ($self, %opt, $opt2, $opt3) = @_;
                    $row_to_update = $opt{data};
                    return 1;
                  }
            }
        );

        $app->do('business_rule_methods', 'export_busines_rules_dict');

        eq_or_diff($row_to_update, $expected_upsert_rows, 'update', {context => 10});
    },
    application_package => 'Cron',
);
