#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_curdate mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::More;
use Test::Differences qw(eq_or_diff);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2020-06-19 12:00:00');

        my @graphite_data = ();

        mock_subs(
            {
                'Application::Model::BKStatistics::get_statistics2' => sub {
                    my ($self) = @_;
                    return {points => []};
                },
                'Cron::Methods::CustomBkData::send_to_graphite' => sub {
                    my (%opts) = @_;

                    push(@graphite_data, \%opts);
                },
            }
        );

        $app->do('custom_bk_data', 'quantity_blocks');

        my $expected = get_test_data_and_update_if_needed('data.json', \@graphite_data);

        eq_or_diff(\@graphite_data, $expected, 'send to graphite');
    },
    application_package => 'Cron',
    dont_create_db      => TRUE,
    mocks               => {mock_send_to_graphite => FALSE},
    init                => ['bk_statistics'],
);
