#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_curdate mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed get_new_mobile_rtb);

use Test::More;
use Test::Differences qw(eq_or_diff);
use PiConstants qw($DAYS_BEFORE_UNSET_GODMODE);

use qbit;

my $yt_data_has = '{"public_id":"C-A-41443-31"}
';
my $yt_data_empty = '';

our $PAGE_ID = 43569;

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2020-06-19 12:00:00');

        my @script_log = ();
        my @action_log = ();
        my $yt_data;

        my @models =
          grep {
                 $_ !~ /^ssp/
              && $app->$_->DOES('Application::Model::Role::Has::CustomBkData')
              && $app->$_->DOES('Application::Model::Role::Has::CustomBkData')
          } @{$app->product_manager->get_block_model_names};

        _generate_block($app);

        mock_subs(
            {
                'Application::Model::BKStatistics::get_statistics2' => sub {
                    my ($self) = @_;
                    return {points => []};
                },
                'Cron::Methods::CustomBkData::INFO' => sub {
                    my ($data) = @_;
                    push @script_log, "INFO:" . $data;
                },
                'Cron::Methods::CustomBkData::ERROR' => sub {
                    my ($data) = @_;
                    push @script_log, "ERROF:" . $data;
                },
                'Cron::Methods::CustomBkData::WARN' => sub {
                    my ($data) = @_;
                    push @script_log, "WARN:" . $data;
                },
                'QBit::Application::Model::API::Yandex::YT::Base::select_rows' => sub {
                    return $yt_data;
                },
            }
        );
        $yt_data = $yt_data_has;
        $app->do('custom_bk_data', 'unset_godmode');

        push @action_log, $app->partner_db->_get_all("select * from $_\_action_log where action = 'edit'")
          for (@models);
        mock_curdate('2020-06-20 12:00:00');
        $yt_data = $yt_data_empty;
        $app->do('custom_bk_data', 'unset_godmode');

        push @action_log, $app->partner_db->_get_all("select * from $_\_action_log where action = 'edit'")
          for (@models);
        mock_curdate('2020-06-21 12:00:00');
        $app->do('custom_bk_data', 'unset_godmode');

        my $data = {
            models     => \@models,
            script_log => \@script_log,
            action_log => \@action_log,
        };

        my $expected = get_test_data_and_update_if_needed('data.json', $data);
        eq_or_diff($data, $expected, 'check log');

    },
    application_package => 'Cron',
    init                => ['bk_statistics'],
);

sub _generate_block {
    my ($app) = @_;

    for (qw(-10 10)) {
        my $public_id =
          $app->mobile_app_rtb->add(get_new_mobile_rtb({context_page_id => $PAGE_ID, dsps => [1], show_video => 0}));
        my $id = (split '-', $public_id)[3];

        $app->partner_db->context_on_site_rtb->edit(
            {
                campaign_id => $PAGE_ID,
                id          => $id,
            },
            {
                bk_data           => "{\"PageID\": $PAGE_ID}",
                is_custom_bk_data => 1,
                create_date => date_sub(curdate(), day => ($DAYS_BEFORE_UNSET_GODMODE + $_), oformat => 'db_time'),
            },
        );
    }
}
