#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::More tests => 2 + 2;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs mock_curdate);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2021-06-30 12:34:56');

        my @test_data;
        my $count = 1;
        mock_subs(
            {
                'Application::Model::DSP::on_action_resend_to_bk' => sub {
                    my $self = shift;

                    push @test_data, sprintf('-=- Iteration: %d -=-', $count++);
                    push @test_data, [];
                    push @{$test_data[-1]}, 'DSP::on_action_resend_to_bk params';
                    push @{$test_data[-1]}, \@_;

                    return $Test::Partner2::Mock::original_subs->{'Application::Model::DSP::on_action_resend_to_bk'}
                      ->($self, @_);
                },
                'QBit::Application::Model::API::Yandex::HTTPBK::apply_dsp_patch' => sub {
                    my $self = shift;

                    push @{$test_data[-1]}, 'HTTPBK::apply_dsp_patch params';
                    push @{$test_data[-1]}, \@_;

                    my $result = $Test::Partner2::Mock::original_subs->{
                        'QBit::Application::Model::API::Yandex::HTTPBK::apply_dsp_patch'}->($self, @_);

                    push @{$test_data[-1]}, 'HTTPBK::apply_dsp_patch result';
                    push @{$test_data[-1]}, $result;

                    return $result;
                },
                'QBit::Application::Model::API::Yandex::HTTPBK::_prepare_dsp_object_for_logbroker' => sub {
                    my $self = shift;

                    push @{$test_data[-1]}, 'HTTPBK::_prepare_dsp_object_for_logbroker params';
                    push @{$test_data[-1]}, \@_;

                    my $result =
                      $Test::Partner2::Mock::original_subs->{
                        'QBit::Application::Model::API::Yandex::HTTPBK::_prepare_dsp_object_for_logbroker'}
                      ->($self, @_);

                    push @{$test_data[-1]}, 'HTTPBK::_prepare_dsp_object_for_logbroker result';
                    push @{$test_data[-1]}, $result;

                    return $result;
                },
                'QBit::Application::Model::API::Yandex::HTTPBK::dsp_lb' => sub {
                    my $self = shift;

                    push @{$test_data[-1]}, 'HTTPBK::dsp_lb params';
                    push @{$test_data[-1]}, \@_;

                    return $Test::Partner2::Mock::original_subs->{
                        'QBit::Application::Model::API::Yandex::HTTPBK::dsp_lb'}->($self, @_);
                },
                'Application::Model::API::Yandex::SelfService::logbroker' => sub {
                    my ($self, %params) = @_;

                    foreach (values %params) {
                        $_ = "$_" if (defined $_ && !ref $_);
                    }
                    push @{$test_data[-1]}, 'SelfService::logbroker params';
                    push @{$test_data[-1]}, \%params;

                    return TRUE;
                },
                'QBit::Cron::check_frequency_limit' => sub {
                    TRUE
                },
            }
        );

        $app->do('dsp', 'resend_dsp_to_bk');

        my $expected = get_test_data_and_update_if_needed("default.json", \@test_data);
        eq_or_diff(\@test_data, $expected, 'default');

        $app->partner_db->dsp->edit($app->partner_db->filter(\1),
            {patch => to_json({'Options.show-public-title' => 1,}),});
        @test_data = ();
        $count     = 1;

        $app->do('dsp', 'resend_dsp_to_bk');

        $expected = get_test_data_and_update_if_needed("with_patch_on_public_title.json", \@test_data);
        eq_or_diff(\@test_data, $expected, 'with patch on PublicTitle');
    },
    application_package => 'Cron',
    init                => [qw(api_http_bk api_selfservice dsp)],
);
