#!/usr/bin/perl -w

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs mock_curdate);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::Deep;
use Test::Differences qw(eq_or_diff);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        $app->bk_statistics;
        mock_curdate('2020-03-30 18:06:37');

        my @sql;
        my %mol_params;
        mock_subs(
            {
                'QBit::Application::Model::DB::_do' => sub {
                    push(@sql, $_[1]);

                    return $Test::Partner2::Mock::original_subs->{'QBit::Application::Model::DB::_do'}->(@_);
                },
                'Application::Model::BKStatistics::get_statistics2' => sub {
                    my ($self, %opts) = @_;
                    %mol_params = %opts;
                    return from_json(
                        q({
                        "totals": {
                          "2": [
                            {
                              "shows": 32
                            }
                          ]
                        },
                        "total_rows": 2,
                        "points": [
                          {
                            "dimensions": {
                              "design_id": 6
                            },
                            "measures": [
                              {
                                "shows": 9
                              }
                            ]
                          },
                          {
                            "dimensions": {
                              "design_id": 7
                            },
                            "measures": [
                              {
                                "shows": 0
                              }
                            ]
                          },
                          {
                            "dimensions": {
                              "design_id": 8
                            },
                            "measures": [
                              {
                                "shows": 5
                              }
                            ]
                          },
                          {
                            "dimensions": {
                              "design_id": 9
                            },
                            "measures": [
                              {
                                "shows": 0
                              }
                            ]
                          },
                          {
                            "dimensions": {
                              "design_id": 10
                            },
                            "measures": [
                              {
                                "shows": 9
                              }
                            ]
                          },
                          {
                            "dimensions": {
                              "design_id": 11
                            },
                            "measures": [
                              {
                                "shows": 0
                              }
                            ]
                          },
                          {
                            "dimensions": {
                              "design_id": 12
                            },
                            "measures": [
                              {
                                "shows": 5
                              }
                            ]
                          },
                          {
                            "dimensions": {
                              "design_id": 13
                            },
                            "measures": [
                              {
                                "shows": 0
                              }
                            ]
                          }
                        ],
                        "dimensions": {
                          "design_id": {
                            "title": "Design ID",
                            "type": "number",
                            "index": 1
                          }
                        },
                        "currencies": [
                          {
                            "code": "USD",
                            "id": "1"
                          },
                          {
                            "code": "RUB",
                            "id": "2"
                          },
                          {
                            "code": "EUR",
                            "id": "3"
                          }
                        ],
                        "report_title": "Report for period 01.04.2019 - 30.03.2021 ",
                        "periods": [
                          [
                            "2019-04-01",
                            "2021-03-10"
                          ]
                        ],
                        "measures": {
                          "shows": {
                            "title": "Ad unit views",
                            "type": "number",
                            "index": 3,
                            "unit": "count"
                          }
                        },
                        "is_last_page": true
                      })
                    );
                  }
            }
        );

        my %design_list;
        $design_list{'1. before'} = $app->design_templates->get_all(fields => [qw(id multistate stat_last_date)],);

        $app->do('dictionaries', 'update_design_templates');

        my $sql = join("\n\n", @sql) . "\n";
        my $expected_sql = get_test_data_and_update_if_needed("update_design_templates.dump", $sql, raw => TRUE);
        eq_or_diff($sql, $expected_sql, 'correct sql requests');
        my $expected_mol = get_test_data_and_update_if_needed(
            "update_design_templates.mol",
            to_json(\%mol_params, pretty => 1),
            raw => TRUE
        );
        eq_or_diff(to_json(\%mol_params, pretty => 1), $expected_mol, 'correct mol params');

        $design_list{'2. after update'} =
          $app->design_templates->get_all(fields => [qw(id multistate stat_last_date)],);

        $app->do('dictionaries', 'cleanup_design_templates');

        $design_list{'3. after cleanup'} =
          $app->design_templates->get_all(fields => [qw(id multistate stat_last_date)],);

        my $expected_design_list = get_test_data_and_update_if_needed(
            "update_design_templates.desings",
            to_json(\%design_list, pretty => 1),
            raw => TRUE
        );
        cmp_deeply(\%design_list, from_json($expected_design_list), 'correct designs');

    },
    application_package => 'Cron',
    init                => [qw(bk_statistics)],
    mocks               => ['mock_sort_sql'],
);
