#!/usr/bin/perl -w

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs mock_curdate);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::Differences qw(eq_or_diff);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        $app->api_yt;
        mock_curdate('2021-03-31 18:06:37');

        _insert_blocks_to_all_blocks($app);

        my %yt_insert_rows_params;
        mock_subs(
            {
                'QBit::Application::Model::API::Yandex::YT::insert_rows' => sub {
                    my ($self, %opts) = @_;
                    %yt_insert_rows_params = %opts;
                    return TRUE;
                  }
            }
        );

        $app->do('dictionaries_yt', 'export_block');

        my $expected = get_test_data_and_update_if_needed(
            "export_block.dump",
            to_json(\%yt_insert_rows_params, pretty => 1),
            raw => TRUE
        );
        eq_or_diff(to_json(\%yt_insert_rows_params, pretty => 1), $expected, 'export_block: correct YT API call');
    },
    application_package => 'Cron',
);

sub _insert_blocks_to_all_blocks {
    my ($app) = @_;

    $app->partner_db->all_blocks->add_multi(
        [
            {
                page_id           => 41443,
                id                => 1,
                model             => 'context_on_site_rtb',
                caption           => 'First RTB block',
                mobile_block_type => undef,
                video_block_type  => undef,
            },
            {
                page_id           => 41443,
                id                => 2,
                model             => 'context_on_site_rtb',
                caption           => 'Second RTB block',
                mobile_block_type => undef,
                video_block_type  => undef,
            },
            {
                page_id           => 41443,
                id                => 3,
                model             => 'search_on_site_direct',
                caption           => 'First Direct block',
                mobile_block_type => undef,
                video_block_type  => undef,
            },
            {
                page_id           => 43569,
                id                => 1,
                model             => 'mobile_app_rtb',
                caption           => 'First Mobile RTB block (no access)',
                mobile_block_type => 'adaptive_banner',
                video_block_type  => undef,
            },
            {
                page_id           => 153980,
                id                => 2,
                model             => 'mobile_app_rtb',
                caption           => '2nd Mobile RTB block (no access)',
                mobile_block_type => 'interstitial',
                video_block_type  => undef,
            },
            {
                page_id           => 154689,
                id                => 1,
                model             => 'video_an_site_instream',
                caption           => 'preroll',
                mobile_block_type => undef,
                video_block_type  => 0,
            },
            {
                page_id           => 154689,
                id                => 2,
                model             => 'video_an_site_instream',
                caption           => 'midroll',
                mobile_block_type => undef,
                video_block_type  => 2,
            },
        ]
    );
}
