#!/usr/bin/perl -w

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs mock_curdate);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::Differences qw(eq_or_diff);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        $app->api_yt;
        mock_curdate('2021-03-31 18:06:37');

        my @yt_insert_rows_params;
        mock_subs(
            {
                'QBit::Application::Model::API::Yandex::YT::insert_rows' => sub {
                    my ($self, %opts) = @_;
                    push(@yt_insert_rows_params, \%opts);
                    return TRUE;
                },
                'QBit::Application::Model::API::Yandex::YT::read_table_from_any_replica' => sub {
                    return '{"id":1,"caption":"Grid","type":"tga","format_name":"grid"}
';
                },
            }
        );

        $app->do('dictionaries_yt', 'export_design_templates');

        my $expected = get_test_data_and_update_if_needed("export_design_templates.dump", \@yt_insert_rows_params,);
        eq_or_diff(\@yt_insert_rows_params, $expected, 'correct YT API call');
    },
    application_package => 'Cron',
);
