#!/usr/bin/perl -w

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs mock_curdate);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::Differences qw(eq_or_diff);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        $app->api_yt;
        mock_curdate('2021-03-31 18:06:37');

        my %yt_insert_rows_params;
        mock_subs(
            {
                'QBit::Application::Model::API::Yandex::YT::insert_rows' => sub {
                    my ($self, %opts) = @_;
                    %yt_insert_rows_params = %opts;
                    return TRUE;
                  }
            }
        );

        $app->do('dictionaries_yt', 'export_pages');

        my $expected = get_test_data_and_update_if_needed(
            "export_pages.dump",
            to_json(\%yt_insert_rows_params, pretty => 1),
            raw => TRUE
        );
        eq_or_diff(to_json(\%yt_insert_rows_params, pretty => 1), $expected, 'export_pages: correct YT API call');
    },
    application_package => 'Cron',
);
