#!/usr/bin/perl -w

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::Differences qw(eq_or_diff);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my @inserted_rows;
        mock_subs(
            {
                'QBit::Application::Model::API::Yandex::YT::insert_rows' => sub {
                    my ($self, %opts) = @_;
                    push(@inserted_rows, \%opts);
                    return TRUE;
                  }
            }
        );

        $app->do('dictionaries_yt', 'export_partner_stat_id');

        my $expected = get_test_data_and_update_if_needed('data.json', \@inserted_rows);
        eq_or_diff(\@inserted_rows, $expected, 'correct YT API call', {context => 3});

    },
    application_package => 'Cron',
);
