#!/usr/bin/perl

use qbit;

use Test::More;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::Differences;
use Utils::MonitoringUtils;

run_tests(
    sub {
        my ($app) = @_;

        my @result;
        mock_subs(
            {
                'QBit::Application::Model::API::Yandex::YT::rewrite_table_on_cluster' => sub {
                    my ($self, %opts) = @_;
                    push @result, {rewrite_table_on_cluster => \%opts};
                },
                'Utils::MonitoringUtils::send_to_graphite' => sub {
                    my (%opts) = @_;
                    push @result, {send_to_graphite => \%opts};
                },
            }
        );

        $app->do('domain', 'get_host_from_content_block');

        my $expected = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $expected, 'checks');
    },
    application_package => 'Cron',
    init                => ['api_yt'],
    mocks               => {mock_send_to_graphite => FALSE,},
);
