#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::Differences;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        $app->api_yt;
        $app->{'api_yt'} = Test::MockObject::Extends->new($app->{'api_yt'});

        my $data;
        $app->api_yt->mock(
            'rewrite_table_on_cluster',
            sub {
                my ($self, %opts) = @_;

                $data = \%opts;

                return TRUE;
            }
        );

        mock_subs(
            {
                'Cron::Methods::FastBan::send_to_graphite' => sub {
                    my (%opts) = @_;

                    eq_or_diff(
                        \%opts,
                        {
                            interval => 'five_min',
                            path     => 'export_fast_ban',
                            value    => 2,
                        },
                        'send_to_graphite'
                    );
                },
            }
        );

        $app->do('fast_ban', 'export_fast_ban');

        my $expected = get_test_data_and_update_if_needed('data.json', $data);

        eq_or_diff($data, $expected, 'Data correct');
    },
    application_package => 'Cron',
);
