#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use File::Slurp qw(write_file);
use Test::Partner2::Simple;

use Test::More;
use qbit;

my @mocked_fias = map {$_->{LIVE_STATUS} //= 1; $_->{SHORT_NAME} = ''; $_} (
    {OBJ_LEVEL => 1,  GUID => 1, PARENT_GUID => undef, FORMAL_NAME => 'REGION'},
    {OBJ_LEVEL => 4,  GUID => 2, PARENT_GUID => 1,     FORMAL_NAME => 'CITY'},
    {OBJ_LEVEL => 65, GUID => 3, PARENT_GUID => 2,     FORMAL_NAME => 'WTF'},
    {OBJ_LEVEL => 90, GUID => 4, PARENT_GUID => 3,     FORMAL_NAME => 'MORE WTF'},
    {OBJ_LEVEL => 7,  GUID => 5, PARENT_GUID => 4,     FORMAL_NAME => 'STREET'},
    {OBJ_LEVEL => 7,  GUID => 6, PARENT_GUID => 4,     FORMAL_NAME => 'DEAD STREET', LIVE_STATUS => 0},
);

run_tests(
    sub {
        my ($app) = @_;

        no strict 'refs';
        no warnings 'redefine';

        *{'QBit::Application::Model::API::Yandex::YT::read_table'} = sub {
            my ($self, %opts) = @_;
            write_file($opts{params}{':content_file'}, map {to_json($_) . "\n"} @mocked_fias);
            return 1;
        };

        *{'Cron::Methods::Fias::_is_valid_guid'} = sub {1};

        *{'Cron::Methods::Fias::FIAS_UPDATE_DATABASES'} = \['partner_db'];

        $app->do('fias', 'update_fias');

        is_deeply(
            $app->partner_db->fias->get_all(fields => [qw(obj_level guid parent_guid formal_name)]),
            [
                {
                    'obj_level'   => '1',
                    'guid'        => '1',
                    'parent_guid' => undef,
                    'formal_name' => 'REGION'
                },
                {
                    'obj_level'   => '4',
                    'guid'        => '2',
                    'parent_guid' => '1',
                    'formal_name' => 'CITY'
                },
                {
                    'obj_level'   => '7',
                    'guid'        => '5',
                    'parent_guid' => '2',
                    'formal_name' => 'STREET'
                }
            ],
            'fias table'
        );

    },
    application_package => 'Cron',
);
