#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Mock qw(mock_subs);
use Test::Deep;
use Test::Partner2::Simple;
use Test::More;
use qbit;

my @DATA = (
    # CLIENT_NUMBER PERIOD_END_DATE REFRESH_DATE
    [
        ['C11009', '2018-01-10T01:00:00Z', '2018-02-10T02:00:00Z'],
        ['C11010', '2018-01-10T01:00:01Z', '2018-02-10T02:00:00Z'],
        ['C11011', '2018-01-10T01:00:02Z', '2018-02-10T02:00:00Z'],
        ['C11009', '2018-02-10T01:00:00Z', '2018-02-10T02:00:00Z'],
        ['C11010', '2018-02-10T01:00:01Z', '2018-02-10T02:00:00Z'],
        ['C11011', '2018-02-10T01:00:02Z', '2018-02-10T02:00:00Z'],
    ],
    [
        ['C11009', '2018-01-10T01:00:00Z', '2018-02-10T02:10:00Z'],
        ['C11010', '2018-01-10T01:00:01Z', '2018-02-10T02:10:00Z'],
        ['C11011', '2018-01-10T01:00:02Z', '2018-02-10T02:10:00Z'],
        ['C11009', '2018-02-10T01:00:00Z', '2018-02-10T02:10:00Z'],
        ['C11010', '2018-02-10T01:00:01Z', '2018-02-10T02:10:00Z'],
        ['C11011', '2018-02-10T01:00:02Z', '2018-02-10T02:10:00Z'],
        ['C11011', '2018-02-10T03:00:00Z', '2018-02-10T04:10:00Z'],
    ],
    []
);

my $AFFECTED_ROWS;

run_tests(
    sub {
        my ($app) = @_;

        $app->kv_store->set('fetch_last_payout', '');

        my %got_data;
        $got_data{'1_init'} = get_user_data($app, [11009, 11010, 11011]);
        $got_data{'1_init_kv'} = $app->kv_store->get('fetch_last_payout');

        my $data;
        mock_subs(
            {
                'Cron::Methods::LastPayout::INFO' => sub {($AFFECTED_ROWS) = $_[0] =~ /Make: (\d+)/},
                'QBit::Application::Model::API::Yandex::YT::read_table_from_any_replica' => sub {
                    return join("\n", map {join "\t", @$_} @$data) . "\n";
                },
            }
        );

        $data = $DATA[0];
        $app->do('last_payout', 'fetch_last_payout');
        $got_data{'2_first'}         = get_user_data($app, [11009, 11010, 11011]);
        $got_data{'2_first_kv'}      = $app->kv_store->get('fetch_last_payout');
        $got_data{'2_affected_rows'} = get_affected_rows();

        $data = $DATA[0];
        $app->do('last_payout', 'fetch_last_payout');
        $got_data{'3_next'}          = get_user_data($app, [11009, 11010, 11011]);
        $got_data{'3_next_kv'}       = $app->kv_store->get('fetch_last_payout');
        $got_data{'3_affected_rows'} = get_affected_rows();

        $data = $DATA[1];
        $app->do('last_payout', 'fetch_last_payout');
        $got_data{'4_next'}          = get_user_data($app, [11009, 11010, 11011]);
        $got_data{'4_next_kv'}       = $app->kv_store->get('fetch_last_payout');
        $got_data{'4_affected_rows'} = get_affected_rows();

        $data = $DATA[2];
        $app->do('last_payout', 'fetch_last_payout');
        $got_data{'5_next'}          = get_user_data($app, [11009, 11010, 11011]);
        $got_data{'5_next_kv'}       = $app->kv_store->get('fetch_last_payout');
        $got_data{'5_affected_rows'} = get_affected_rows();

        my $has_data = get_test_data_and_update_if_needed('data.json', \%got_data);
        cmp_deeply(from_json(to_json(\%got_data)), $has_data, "compare data");
    },
    application_package => 'Cron',
    init                => [qw(users)],
);

sub get_user_data {
    my ($app, $ids) = @_;
    my $list = $app->users->get_all(
        filter => [client_id => 'IN' => $ids],
        fields   => ['id',  'client_id', 'last_payout'],
        order_by => [['id', TRUE]],
    );
    return $list;
}

sub get_affected_rows {
    my $affected_rows = $AFFECTED_ROWS;

    $AFFECTED_ROWS = 0;

    return $affected_rows;
}
