#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);

use Test::More tests => 4;
use PiConstants qw($MONEY_THRESHOLD $MAIL_NOTIFICATION_TYPES);

use qbit;
use DDP;

my ($LOGIN_1, $LOGIN_2) = ('login1', 'login2');

run_tests(
    sub {
        my ($app) = @_;

        my $USER_ID_1 = $app->partner_db->users->add(
            {
                login => $LOGIN_1,
                email => "$LOGIN_1\@yandex.ru",
                opts  => to_json({is_form_done => 0,}),
            }
        );

        $app->partner_db->form_data->add(
            {
                user_id   => $USER_ID_1,
                branch_id => 'russia_ph_part2',
            }
        );

        my $USER_ID_2 = $app->partner_db->users->add(
            {
                login => $LOGIN_2,
                email => "$LOGIN_2\@yandex.ru",
                opts  => to_json({is_form_done => 1,}),
            }
        );

        $app->partner_db->form_data->add(
            {
                user_id   => $USER_ID_2,
                branch_id => 'russia_ph_part1',
            }
        );

        mock_subs(
            {
                'Application::Model::BKStatistics::get_statistics2' => sub {
                    my ($self, %params) = @_;

                    my $logins = $params{levels}[0]{filter}[1][0][2];

                    ok(in_array($LOGIN_1, $logins), 'user with flag in query');
                    ok(!in_array($LOGIN_2, $logins), 'user without flag is not in query');

                    return {points => []};
                },
            }
        );

        $app->do('mail_notification', 'find_incomplete');
    },
    application_package => 'Cron',
    init                => ['bk_statistics'],
);
