#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use File::Slurp qw(write_file);
use Test::Partner2::Simple;
use Test::Partner2::Mock qw(restore_subs);

use Test::More;
use Test::Differences;
use qbit;

$ENV{LAZY_LOAD} = FALSE;

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);

        # Наливаем
        $app->partner_db->all_pages->add_multi(
            [
                {
                    'domain'                => 'showmethemoney.ru',
                    'is_balance_registered' => TRUE,
                    'login'                 => 'mocked-yan-partner',
                    'model'                 => 'context_on_site_campaign',
                    'multistate'            => 16,
                    'page_id'               => 1
                },
                {
                    'domain'                => 'showmethemoney.ru',
                    'is_balance_registered' => TRUE,
                    'login'                 => 'mocked-yan-partner',
                    'model'                 => 'search_on_site_campaign',
                    'multistate'            => 16,
                    'page_id'               => 111161
                },
                {
                    'domain'  => 'app.test.com',
                    'login'   => 'rubiconproject2015',
                    'model'   => 'mobile_app_settings',
                    'page_id' => 203
                },
                {
                    'domain'  => 'kinopoisk.ru',
                    'login'   => 'mocked-video-partner',
                    'model'   => 'video_an_site',
                    'page_id' => 128972
                },
                {
                    'domain'                => 'showmethemoney.ru',
                    'is_balance_registered' => TRUE,
                    'login'                 => 'adinside',
                    'model'                 => 'internal_context_on_site_campaign',
                    'multistate'            => 16,
                    'page_id'               => 2
                },
                {
                    'domain'                => 'showmethemoney.ru',
                    'is_balance_registered' => TRUE,
                    'login'                 => 'adinside',
                    'model'                 => 'internal_search_on_site_campaign',
                    'multistate'            => 16,
                    'page_id'               => 118826
                },
                {
                    'domain'                => 'кириллица.рф',
                    'is_balance_registered' => TRUE,
                    'login'                 => 'adinside',
                    'model'                 => 'internal_mobile_app',
                    'multistate'            => 16,
                    'page_id'               => 132439
                }
            ]
        );

        $app->do('metrika', 'create_page_counters');

        # Проверяем
        my $got = $app->partner_db->query->select(
            table  => $app->partner_db->all_pages,
            fields => [qw( page_id  model  login)],
          )->left_join(
            table   => $app->partner_db->metrika_counters,
            alias   => 'MK',
            fields  => [qw( counter_id )],
            join_on => ['page_id' => '=' => {'page_id' => $app->partner_db->all_pages}]
          )->order_by(qw( model  page_id ))->get_all();

        my $expect = [
            {
                'counter_id' => 7701,
                'login'      => 'mocked-yan-partner',
                'model'      => 'context_on_site_campaign',
                'page_id'    => 1
            },
            {
                'counter_id' => 7702,
                'login'      => 'adinside',
                'model'      => 'internal_context_on_site_campaign',
                'page_id'    => 2
            },
            {
                'counter_id' => undef,        # NOTE! для МОБИЛЬНЫХ счетчики не создаются
                'login'      => 'adinside',
                'model'   => 'internal_mobile_app',
                'page_id' => 132439
            },
            {
                'counter_id' => 7703,
                'login'      => 'adinside',
                'model'      => 'internal_search_on_site_campaign',
                'page_id'    => 118826
            },
            {
                'counter_id' => undef,        # NOTE! для МОБИЛЬНЫХ счетчики не создаются
                'login'   => 'rubiconproject2015',
                'model'   => 'mobile_app_settings',
                'page_id' => 203
            },
            {
                'counter_id' => 7704,
                'login'      => 'mocked-yan-partner',
                'model'      => 'search_on_site_campaign',
                'page_id'    => 111161
            },
            {
                'counter_id' => undef,        # NOTE! для ВИДЕО счетчики не создаются
                'login'   => 'mocked-video-partner',
                'model'   => 'video_an_site',
                'page_id' => 128972
            }
        ];

        eq_or_diff($got, $expect, 'Created metrika counters');
        #        cmp_deeply($got, $expect, 'Created metrika counters');
    },
    application_package => 'Cron',
    keep_databases      => TRUE,
);

sub mock_app {
    my ($app) = @_;

    # NOTE! По дефолту используется вьюха
    restore_subs([qw(Application::Model::PartnerDB::all_pages)]);

    my $counter = 7700;

    $app->{'api_metrika'} = Test::MockObject::Extends->new($app->{'api_metrika'});
    $app->api_metrika->mock(
        'call',
        sub {
            return (sprintf '{"counter":{"id":%d}}', ++$counter);
        }
    );
}
