#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs restore_subs);

use Test::Differences;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);

        mock_subs(
            {
                'Cron::Methods::Metrika::ERRORF' => sub {
                    eq_or_diff(\@_, ['Metrika counters missed count=[%d]', 12], '12 Metrika counters missed');
                },
                'Cron::Methods::Metrika::send_to_graphite' => sub {
                    eq_or_diff(
                        {@_},
                        {
                            interval => "one_hour",
                            path     => 'Metrika.counters.not_found',
                            value    => 12,
                        },
                        'send_to_graphite 12'
                    );
                },
            }
        );
        $app->do('metrika', 'find_pages_with_deleted_metrika_counters');

        restore_subs(['Cron::Methods::Metrika::ERRORF', 'Cron::Methods::Metrika::send_to_graphite']);

        mock_subs(
            {
                'Cron::Methods::Metrika::INFO' => sub {
                    eq_or_diff(\@_, ['no Metrika counters missed'], 'no Metrika counters missed');
                },
                'Cron::Methods::Metrika::send_to_graphite' => sub {
                    eq_or_diff(
                        {@_},
                        {
                            interval => "one_hour",
                            path     => 'Metrika.counters.not_found',
                            value    => 0,
                        },
                        'send_to_graphite 0'
                    );
                },
            }
        );
        $app->do('metrika', 'find_pages_with_deleted_metrika_counters');

    },
    application_package  => 'Cron',
    dont_create_database => 1,
);

sub mock_app {
    my ($app) = @_;

    my $first_call       = TRUE;
    my $YQL_OPERATION_ID = 111;

    $app->api_yql;
    $app->{'api_yql'} = Test::MockObject::Extends->new($app->{'api_yql'});

    $app->api_yql->mock(
        '_yql_start_operation',
        sub {
            my ($self, $params) = @_;
            my $r = $first_call ? $YQL_OPERATION_ID : $YQL_OPERATION_ID + 1;
            $first_call = FALSE;
            return $r;
        }
    );

    $app->api_yql->mock(
        '_yql_get_operation_result',
        sub {
            my ($self, $operation_id, %opts) = @_;

            my $json_str =
              to_json($operation_id == $YQL_OPERATION_ID ? {deleted_counters => 12} : {deleted_counters => 0});

            return $json_str;
        }
    );
}
