#!/usr/bin/perl -w

use Clone qw(clone);
use File::Basename;
use Test::Exception;
use Test::More tests => 7;
use Test::Differences qw(eq_or_diff);

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs mock_curdate);
use Test::Partner::Utils qw(get_test_data_path get_test_data_and_update_if_needed);

use qbit;
use Utils::JSON qw();

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2022-04-28 08:01:15');

        # Initialize before replace methods
        $app->api_yql;
        $app->exception_dumper;

        my $moderation = Cron::Methods::Moderation->new('app' => $app,);

        my $product_get    = \&Application::Model::Product::get_all;
        my $db_manager_get = \&QBit::Application::Model::DBManager::get_all;

        my $mocked_get_all_data      = [];
        my $get_all_args             = undef;
        my $on_verdict_received_args = undef;
        my $got_do_action_args       = undef;
        my $mysq_table_edit_args     = undef;
        my $on_done_moderation_args  = undef;
        my $warn_messages            = undef;
        mock_subs(
            {
                'Application::Model::Product::get_all' => sub {
                    my ($self, @opts) = @_;
                    goto $product_get if (caller ne 'Cron::Methods::Moderation');
                    $get_all_args = {
                        accessor => $self->accessor(),
                        @opts
                    };
                    return $mocked_get_all_data;
                },
                'QBit::Application::Model::DBManager::get_all' => sub {
                    my ($self, @opts) = @_;
                    # goto $db_manager_get;
                    goto $db_manager_get if (caller ne 'Cron::Methods::Moderation');
                    $get_all_args = {
                        accessor => $self->accessor(),
                        @opts
                    };
                    return $mocked_get_all_data;
                },
                'Application::Model::Role::Has::FieldsModeration::on_verdict_received' => sub {
                    my ($self, $block, $moderation_data) = @_;
                    $on_verdict_received_args = {
                        accessor        => $self->accessor(),
                        block           => $block,
                        moderation_data => $moderation_data
                    };
                    return TRUE;
                },
                'QBit::Application::Model::Multistate::DB::do_action' => sub {
                    my ($self, $id, $action, %opts) = @_;
                    $got_do_action_args //= [];
                    push @$got_do_action_args,
                      {
                        accessor => $self->accessor(),
                        id       => $id,
                        action   => $action,
                        opts     => \%opts
                      };
                },
                'QBit::Application::Model::DB::mysql::Table::edit' => sub {
                    my ($self, @args) = @_;
                    $mysq_table_edit_args //= [];
                    push @$mysq_table_edit_args, {@args};
                },
                'Application::Model::Role::Has::Moderation::on_done_moderation' => sub {
                    my ($self, $id) = @_;
                    $on_done_moderation_args = {
                        accessor => $self->accessor(),
                        id       => $id
                    };
                },
                'Cron::Methods::Moderation::WARN' => sub {
                    my ($data) = @_;
                    $warn_messages //= [];
                    push @$warn_messages, $data->{message};
                  }
            }
        );

        my $files = [glob get_test_data_path() . '/*.json'];
        foreach my $fixture_json (@$files) {

            my $has = from_json readfile($fixture_json);

            my $got      = [];
            my $got_yqls = [];
            foreach my $test (@$has) {

                $get_all_args             = undef;
                $got_do_action_args       = undef;
                $mysq_table_edit_args     = undef;
                $on_verdict_received_args = undef;
                $on_done_moderation_args  = undef;
                $warn_messages            = undef;

                my ($row, $get_all_data, $has_exception) = @{$test}{
                    qw(
                      row
                      get_all_data
                      exception
                      )
                  };

                $mocked_get_all_data = $get_all_data;

                my $got_counter = {};
                my $got_exception;
                try {
                    $moderation->apply_verdict($row, $got_counter);
                }
                catch {
                    ($got_exception) = @_;
                };

                my $got_data = {
                    %$test,
                    counter                  => $got_counter,
                    do_action_args           => $got_do_action_args,
                    get_all_args             => $get_all_args,
                    mysq_table_edit_args     => $mysq_table_edit_args,
                    on_done_moderation_args  => $on_done_moderation_args,
                    on_verdict_received_args => $on_verdict_received_args,
                    warn                     => $warn_messages
                };
                foreach my $key (keys %$got_data) {
                    delete $got_data->{$key} if $key =~ /(_args|warn)/ && !defined $got_data->{$key};
                }

                if ($got_exception || $has_exception) {
                    my $message = $got_exception->message if $got_exception;
                    $got_data->{exception} = [ref($got_exception), $message];
                }

                push @$got, $got_data;
            }

            my $file_name = basename($fixture_json);
            get_test_data_and_update_if_needed($file_name, $got);

            my $model = $has->[0]->{row}->{meta}->{model};
            eq_or_diff($got, $has, $model . '.  apply_verdict', {context => 5});
        }
    },
);
