#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::More tests => 5;

use Test::Partner2::Simple;

my @model =
  (qw(context_on_site_mirrors indoor indoor_block mobile_app outdoor outdoor_block search_on_site_mirrors site));

run_tests(
    sub {
        my ($app) = @_;

        # Cron::Methods::Moderation::check_too_long_moderation tests

        no strict 'refs';
        no warnings 'redefine';

        my $get_all = \&QBit::Application::Model::DB::Table::get_all;
        local *{'QBit::Application::Model::DB::Table::get_all'};
        local *{'Cron::Methods::Moderation::ERROR'};
        local *{'Cron::Methods::Moderation::send_to_graphite'};

        subtest empty => sub {
            plan tests => 1 + 2 * @model;

            my $err;
            my $n     = 0;
            my $first = 1;
            *{'QBit::Application::Model::DB::Table::get_all'} = sub {
                return [] if (caller eq 'Cron::Methods::Moderation');
                goto &$get_all;
            };
            *{'Cron::Methods::Moderation::ERROR'} = sub {
                $err = 1;
                fail(sprintf('ERRORF: %s', $model[$n]));
            };
            *{'Cron::Methods::Moderation::send_to_graphite'} = sub {
                if ($first) {
                    eq_or_diff(
                        {@_},
                        {
                            interval => 'five_min',
                            path     => sprintf('Moderation.%s_outdated', $model[$n]),
                            value    => 0,
                            solomon  => {
                                model  => $model[$n],
                                sensor => 'Moderation.outdated',
                            }
                        },
                        sprintf('send_to_graphite, outdated: %s', $model[$n])
                    );
                } else {
                    eq_or_diff(
                        {@_},
                        {
                            interval => 'five_min',
                            path     => sprintf('Moderation.%s_current', $model[$n]),
                            value    => 0,
                            solomon  => {
                                model  => $model[$n],
                                sensor => 'Moderation.current',
                            }
                        },
                        sprintf('send_to_graphite, current: %s', $model[$n])
                    );
                    $n++;    # last check in iteration
                }
                $first = !$first;
            };
            $app->do(qw( moderation check_too_long_moderation ));
            pass('check_too_long_moderation') unless ($err);
        };

        subtest zero => sub {
            plan tests => 1 + 2 * @model;

            my $err;
            my $n     = 0;
            my $first = 1;
            *{'QBit::Application::Model::DB::Table::get_all'} = sub {
                return [{'count' => 0,}] if (caller eq 'Cron::Methods::Moderation');
                goto &$get_all;
            };
            *{'Cron::Methods::Moderation::ERROR'} = sub {
                $err = 1;
                fail(sprintf('ERRORF: %s', $model[$n]));
            };
            *{'Cron::Methods::Moderation::send_to_graphite'} = sub {
                if ($first) {
                    eq_or_diff(
                        {@_},
                        {
                            interval => 'five_min',
                            path     => sprintf('Moderation.%s_outdated', $model[$n]),
                            value    => 0,
                            solomon  => {
                                model  => $model[$n],
                                sensor => 'Moderation.outdated',
                            }
                        },
                        sprintf('send_to_graphite, outdated: %s', $model[$n])
                    );
                } else {
                    eq_or_diff(
                        {@_},
                        {
                            interval => 'five_min',
                            path     => sprintf('Moderation.%s_current', $model[$n]),
                            value    => 0,
                            solomon  => {
                                model  => $model[$n],
                                sensor => 'Moderation.current',
                            }
                        },
                        sprintf('send_to_graphite, current: %s', $model[$n])
                    );
                    $n++;    # last check in iteration
                }
                $first = !$first;
            };
            $app->do(qw( moderation check_too_long_moderation ));
            pass('check_too_long_moderation') unless ($err);
        };

        subtest '2 elements' => sub {
            plan tests => 3 * @model;

            my $err;
            my $n     = 0;
            my $first = 1;
            *{'QBit::Application::Model::DB::Table::get_all'} = sub {
                return [{'count' => 2, 'too_long' => 1,}, {'count' => 3, 'too_long' => 0,}]
                  if (caller eq 'Cron::Methods::Moderation');
                goto &$get_all;
            };
            *{'Cron::Methods::Moderation::ERROR'} = sub {
                $err = 1;
                eq_or_diff(
                    \@_,
                    [
                        {
                            message => sprintf(
                                'There are %d elements in %s have state need_approve for a long time',
                                2, $model[$n]
                            ),
                            fingerprint => ['Cron', 'check_too_long_moderation', $model[$n]],
                        },
                    ],
                    sprintf('ERRORF: %s', $model[$n])
                );
            };
            *{'Cron::Methods::Moderation::send_to_graphite'} = sub {
                if ($first) {
                    eq_or_diff(
                        {@_},
                        {
                            interval => 'five_min',
                            path     => sprintf('Moderation.%s_outdated', $model[$n]),
                            value    => 2,
                            solomon  => {
                                model  => $model[$n],
                                sensor => 'Moderation.outdated',
                            }
                        },
                        sprintf('send_to_graphite, outdated: %s', $model[$n])
                    );
                } else {
                    eq_or_diff(
                        {@_},
                        {
                            interval => 'five_min',
                            path     => sprintf('Moderation.%s_current', $model[$n]),
                            value    => 5,
                            solomon  => {
                                model  => $model[$n],
                                sensor => 'Moderation.current',
                            }
                        },
                        sprintf('send_to_graphite, current: %s', $model[$n])
                    );
                    $n++;    # last check in iteration
                }
                $first = !$first;
            };
            $app->do(qw( moderation check_too_long_moderation ));
            fail('check_too_long_moderation') unless ($err);
        };
    },
    'application_package' => 'Cron',
);
