#!/usr/bin/perl -w

use Clone qw(clone);
use File::Basename;
use Test::Exception;
use Test::More;
use Test::Differences qw(eq_or_diff);

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use qbit;
use Utils::JSON qw();

use Test::Partner::Utils qw(get_new_site);
use Test::Partner2::Mock qw(mock_zora mock_mailer);
use Test::Partner2::Mock qw(mock_subs restore_subs);

my $DATE    = '2017-01-04 12:32:05';
my $SITE_ID = undef;

run_tests(
    sub {
        my ($app) = @_;

        mock_zora($app);
        mock_mailer($app);

        mock_mailer($app);
        mock_zora($app);
        mock_balance($app);
        mock_bk($app);
        mock_utils_partner2($app);

        mock_curdate($DATE);

        mock_subs(
            {
                'Cron::Methods::Moderation::get_verdicts' => sub {
                    [
                        {
                            table_name  => 'context_on_site_campaign',
                            service     => 'pi',
                            type        => 'site',
                            meta        => {id => $SITE_ID || 123, model => 'site'},
                            mod_results => {
                                verdict => 'No',
                                reasons => [18]
                            },
                        }
                    ];
                },
            }
        );

        change_cur_user($app, 'mocked-yan-partner');

        my $domain = 'partner.com';
        $SITE_ID = $app->site->add(domain => $domain);

        my $page_id_1 = $app->context_on_site_campaign->add(
            caption   => 'page 1',
            domain_id => $SITE_ID,
        );

        my $page_id_2 = $app->context_on_site_campaign->add(
            caption   => 'page 2',
            domain_id => $SITE_ID,
        );

        my $tmp_rights = $app->add_tmp_rights(qw(do_context_on_site_set_protected do_context_on_site_approve));

        $app->context_on_site_campaign->do_action($page_id_1, 'approve');
        $app->context_on_site_campaign->do_action($page_id_2, 'set_protected');

        my %query = (
            fields => [qw(caption domain multistate_name)],
            filter => [all_domain => 'LIKE' => $domain],
        );

        my $before = $app->context_on_site_campaign->get_all(%query);

        eq_or_diff(
            $before,
            [
                {
                    caption         => 'page 1',
                    domain          => 'partner.com',
                    multistate_name => 'New',
                },
                {
                    caption         => 'page 2',
                    domain          => 'partner.com',
                    multistate_name => "Need approve.\nProtected"
                }
            ],
            'mulitstates before check_verdicts'
        );

        $app->do('moderation', 'check_verdicts');

        my $after = $app->context_on_site_campaign->get_all(%query);
        eq_or_diff(
            $after,
            [
                {
                    caption         => 'page 1',
                    domain          => 'partner.com',
                    multistate_name => 'Rejected',
                },
                {
                    caption         => 'page 2',
                    domain          => 'partner.com',
                    multistate_name => "Need approve.\nProtected"
                }
            ],
            'mulitstates arfter check_verdicts'
        );

        ok($after->[0]->{multistate_name} ne $before->[0]->{multistate_name}, 'Page was rejected');
        ok($after->[1]->{multistate_name} eq $before->[1]->{multistate_name}, 'Protected page was not rejected');

    },
    application_package => 'Cron',
);
