#!/usr/bin/perl -w

use Clone qw(clone);
use Test::Exception;
use Test::More tests => 4;
use Test::Differences qw(eq_or_diff);

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs mock_curdate);
use Test::Partner::Utils qw(get_test_data_path get_test_data_and_update_if_needed);

use qbit;
use Utils::JSON ();

my $query_sep = "\n--------\n";

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2022-04-28 08:01:15');

        my $moderation = Cron::Methods::Moderation->new('app' => $app,);

        my $got_yql                     = '';
        my $mocked_yql_operation_result = '';
        mock_subs(
            {
                'QBit::Application::Model::API::Yandex::YQL::yql_start_operation_and_get_result' => sub {
                    my ($self, %opts) = @_;
                    $got_yql = trim_query($opts{start_params}->{params}->{content});
                    return $mocked_yql_operation_result;
                  }
            }
        );

        my $has = from_json readfile(get_test_data_path() . '/data.json');
        my $has_yqls = [map {chomp; $_} split /$query_sep/, readfile(get_test_data_path() . '/yql.txt')];

        my $got      = [];
        my $got_yqls = [];
        for (my $i = 0; $i <= $#$has; $i++) {
            my $test = $has->[$i];

            $got_yql                     = '';
            $mocked_yql_operation_result = '';

            my ($last_table, $results, $opts, $has_exception) = @{$test}{qw(last_table results opts exception)};

            my $mocked_yql_data = clone($results);
            $mocked_yql_operation_result = make_yql_jsonl($mocked_yql_data);

            my ($got_verdicts, $got_exception) = $moderation->get_verdicts($last_table, undef, $opts);

            my $got_data = {%$test, verdicts => $got_verdicts};
            if ($got_exception || $has_exception) {
                my $message = $got_exception->message if $got_exception;
                $got_data->{exception} = [ref($got_exception), $message];
            }

            push @$got,      $got_data;
            push @$got_yqls, $got_yql;
        }

        get_test_data_and_update_if_needed('data.json', $got);
        get_test_data_and_update_if_needed('yql.txt', join($query_sep, @$got_yqls) . "\n", 'raw' => 1);

        eq_or_diff($got,      $has,      '_get_verdicts',     {context => 5});
        eq_or_diff($got_yqls, $has_yqls, '_get_verdicts YQL', {context => 5});
    },
    application_package => 'Cron',
    init                => [qw(api_yql exception_dumper)],
);

sub make_yql_jsonl {
    my ($mocked_yql_data) = @_;
    my $mocked_yql_operation_result = '';
    foreach my $row (@$mocked_yql_data) {
        foreach my $key (qw(meta mod_results)) {
            $row->{$key} = to_json($row->{$key});
        }
        $mocked_yql_operation_result .= to_json($row, canonical => 1) . "\n";
    }
    return $mocked_yql_operation_result;
}

sub trim_query {
    my ($yql) = @_;
    $yql =~ s/^\n+//;
    my ($pre) = ($yql =~ /^(\s+)/);
    $yql =~ s/^$pre//mg if $pre;
    $yql =~ s/\s+$//;
    return $yql;
}
