#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);
use Test::Partner2::Fixture;

use Test::More tests => 3;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        $app->do('dictionaries', 'update_all_blocks');

        my $block = get_fixture('partner_context_rtb_block');

        no strict 'refs';
        no warnings 'redefine';
        *{'Application::Model::SendMail::send'} = sub {
            my ($self, %opts) = @_;

            fail('No blocks found, but send called');
        };

        $app->do('monitoring', 'empty_dsps_monitoring');

        $app->partner_db->block_dsps->delete(
            $app->partner_db->filter(
                [AND => [[page_id => '=' => \$block->{campaign_id}], [block_id => '=' => \$block->{id}],]]
            )
        );

        *{'Application::Model::SendMail::send'} = sub {
            my ($self, %opts) = @_;

            is($opts{body}, $app->context_on_site_rtb->public_id($block), 'block found');
        };

        $app->do('monitoring', 'empty_dsps_monitoring');
    },
    application_package => 'Cron',
    fill_databases      => 0,
    fixtures            => ['partner_context_rtb_block'],
);
