#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_curdate mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::More;
use Test::Differences qw(eq_or_diff);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2019-03-25 18:48:42');

        my @graphite_data = ();

        mock_subs(
            {
                'QBit::Application::Model::DB::Table::get_all' => sub {
                    my ($self, %opts) = @_;

                    if ($self->name eq 'kv_store') {
                        return [map {{key => $_, last_change => '2019-03-25 18:10:32'}} @{$opts{'filter'}->{'key'}}];
                    }

                    return $Test::Partner2::Mock::original_subs->{'QBit::Application::Model::DB::Table::get_all'}
                      ->($self, %opts);
                },
                'Cron::Methods::Monitoring::send_to_graphite' => sub {
                    my (%opts) = @_;

                    push(@graphite_data, \%opts);
                },
            }
        );

        $app->do('monitoring', 'last_update_stat');

        my $expected = get_test_data_and_update_if_needed('data.json', \@graphite_data);

        eq_or_diff(\@graphite_data, $expected, 'send to graphite');
    },
    application_package => 'Cron',
    dont_create_db      => TRUE,
    mocks               => {mock_send_to_graphite => FALSE},
);
