use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Differences;

use Test::Partner::Utils;
use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs mock_curdate);

use qbit;

my $tests = [
    {
        title => 'no new notifications',
        data  => unset_utf(to_json({'response' => {"innList" => []}})),
    },
    {
        title => 'get new notifications',
        data  => unset_utf(
            to_json(
                {
                    'response' => {
                        "innList" => [
                            {
                                "inn"           => '123456789012',
                                "notifications" => [
                                    {
                                        "id"            => 10,
                                        "title"         => "Заголовок уведомления 1",
                                        "message"       => "Текст уведомления 1",
                                        "status"        => "NEW",
                                        "createdAt"     => "19T11:52:01.392Z",
                                        "updatedAt"     => "19T11:52:01.392Z",
                                        "partnerId"     => "1",
                                        "applicationId" => "2"
                                    },
                                    {
                                        "id"            => 11,
                                        "title"         => "Заголовок уведомления 2",
                                        "message"       => "Текст уведомления 2",
                                        "status"        => "NEW",
                                        "createdAt"     => "19T11:52:01.392Z",
                                        "updatedAt"     => "19T11:52:01.392Z",
                                        "partnerId"     => "1",
                                        "applicationId" => "2"
                                    }
                                ]
                            }
                        ]
                    }
                }
            )
        ),
    },
    {
        title => 'synchronize notifications status',
        data  => unset_utf(
            to_json(
                {
                    'response' => {
                        "innList" => [
                            {
                                "inn"           => '123456789012',
                                "notifications" => [
                                    {
                                        "id"            => 10,
                                        "title"         => "Заголовок уведомления 1",
                                        "message"       => "Текст уведомления 1",
                                        "status"        => "ACKNOWLEDGED",
                                        "createdAt"     => "19T11:52:01.392Z",
                                        "updatedAt"     => "19T11:52:01.392Z",
                                        "partnerId"     => "1",
                                        "applicationId" => "2"
                                    },
                                    {
                                        "id"            => 11,
                                        "title"         => "Заголовок уведомления 2",
                                        "message"       => "Текст уведомления 2",
                                        "status"        => "ARCHIVED",
                                        "createdAt"     => "19T11:52:01.392Z",
                                        "updatedAt"     => "19T11:52:01.392Z",
                                        "partnerId"     => "1",
                                        "applicationId" => "2"
                                    }
                                ]
                            }
                        ]
                    }
                }
            )
        ),
    }
];

my $test_data;

run_tests(
    sub {
        my ($app) = @_;

        my $result;
        my $tmp = $app->add_all_tmp_rights();
        mock_subs(
            {
                'QBit::Application::Model::API::HTTP::request' => sub {
                    my ($self, %params) = @_;
                    $params{content} = from_json($params{content}) if defined $params{content};
                    return $test_data;
                },
                'Application::Model::API::Yandex::TVM::get_service_ticket' => sub {
                    return "3:serv:CPlMEP";
                },
            }
        );

        mock_curdate("2020-07-17 10:10:00");
        my @result;
        for my $test (@$tests) {
            $result = {title => $test->{title}};
            $test_data = $test->{data};
            $app->do('self_employed_check', 'get_fns_notifications');
            $result->{data} = get_user_notifications($app, 1010);
            push @result, $result;
        }

        my $has = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(from_json(to_json(\@result)), $has, 'body');
    },
    application_package => 'Cron',
    init                => [qw(api_selfemployed_oebs api_tvm)],
);

sub get_user_notifications {
    my ($app, $user_id) = @_;
    my $result = $app->user_notifications->get_all(
        filter => {user_id => $user_id},
        fields => [qw(id caption message multistate multistate_name)]
    );
    return $result;
}
