#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Mock qw(mock_subs);
use Test::Deep;
use Test::Partner2::Simple;
use Test::More;
use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my %got_data;
        $got_data{'1_before'} = get_user_data($app, [11010, 11011]);
        $got_data{'1_before_1'} = get_user_notifications_data($app, [1010, 1011]);

        my $data;
        mock_subs(
            {
                'Application::Model::Documents::get_active_contract' => sub {
                    return {
                        Person   => {},
                        Contract => {selfemployed => ($_[1]->{client_id} // 0) == 11011},
                    };
                  }
            }
        );

        $app->do('self_employed_check', 'get_from_balance');
        $got_data{'2_after'} = get_user_data($app, [11010, 11011]);
        $got_data{'2_after_1'} = get_user_notifications_data($app, [1010, 1011]);

        my $has_data = get_test_data_and_update_if_needed('data.json', \%got_data);
        cmp_deeply(from_json(to_json(\%got_data)), $has_data, "compare data");
    },
    application_package => 'Cron',
    init                => [qw(users documents)],
);

sub get_user_data {
    my ($app, $ids) = @_;
    my $list = $app->users->get_all(
        filter => [client_id => 'IN' => $ids],
        fields   => ['id',  'client_id', 'self_employed', 'self_employed_request_id',],
        order_by => [['id', TRUE]],
    );

    return $list;
}

sub get_user_notifications_data {
    my ($app, $user_ids) = @_;
    return $app->user_notifications->partner_db->query->select(
        table  => $app->user_notifications->partner_db_table(),
        fields => [qw(user_id notification_id)],
        filter => [user_id => 'IN' => \$user_ids],
    )->get_all();
}
