#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Differences;
use Test::More;

use Test::Partner2::Simple;
use qbit;

my %RO = (
    context_on_site_campaign => TRUE,
    mobile_app_settings      => FALSE,
);

run_tests(
    sub {
        my ($app) = @_;

        subtest default => sub {
            plan tests => 5;

            no strict 'refs';
            no warnings 'redefine';

            local *{'Application::Model::ProductManager::get_page_model_accessors'} = sub {
                my ($self, %opts) = @_;

                eq_or_diff(\%opts, {}, 'get_page_model_accessors opts');

                return [qw(context_on_site_campaign mobile_app_settings)];
            };
            local *{'Application::Model::Page::check_read_only_and_protected_status'} = sub {
                my ($self, %opts) = @_;

                ok(in_array($self->accessor(), [qw(context_on_site_campaign mobile_app_settings)]),
                    'check_read_only_and_protected_status accessor');

                eq_or_diff(
                    \%opts,
                    {
                        page_id         => undef,
                        check_ro_status => $RO{$self->accessor()},
                    },
                    'check_read_only_and_protected_status opts'
                );
                return (0, 0);
            };
            local @ARGV = qw(system check_read_only_and_protected);
            $app->do();
        };

        subtest model => sub {
            plan tests => 2;

            no strict 'refs';
            no warnings 'redefine';

            local *{'Application::Model::ProductManager::get_page_model_accessors'} = sub {
                my ($self, %opts) = @_;

                fail 'get_page_model_accessors opts';
            };
            local *{'Application::Model::Page::check_read_only_and_protected_status'} = sub {
                my ($self, %opts) = @_;

                eq_or_diff($self->accessor(), 'mobile_app_settings', 'check_read_only_and_protected_status accessor');

                eq_or_diff(
                    \%opts,
                    {
                        page_id         => undef,
                        check_ro_status => $RO{$self->accessor()},
                    },
                    'check_read_only_and_protected_status opts'
                );
                return (0, 0);
            };
            local @ARGV = qw(system check_read_only_and_protected model mobile_app_settings);
            $app->do();
        };

        subtest page_id => sub {
            plan tests => 5;

            no strict 'refs';
            no warnings 'redefine';

            local *{'Application::Model::ProductManager::get_page_model_accessors'} = sub {
                my ($self, %opts) = @_;

                eq_or_diff(\%opts, {}, 'get_page_model_accessors opts');

                return [qw(context_on_site_campaign mobile_app_settings)];
            };
            local *{'Application::Model::Page::check_read_only_and_protected_status'} = sub {
                my ($self, %opts) = @_;

                ok(in_array($self->accessor(), [qw(context_on_site_campaign mobile_app_settings)]),
                    'check_read_only_and_protected_status accessor');

                eq_or_diff(
                    \%opts,
                    {
                        page_id         => ['123456'],
                        check_ro_status => $RO{$self->accessor()},
                    },
                    'check_read_only_and_protected_status opts'
                );
                return (0, 0);
            };
            local @ARGV = qw(system check_read_only_and_protected page_id 123456);
            $app->do();
        };

    },
    application_package => 'Cron',
    init                => [qw(context_on_site_campaign mobile_app_settings product_manager)],
);
