#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Partner::Utils;
use Test::Partner2::Mock;
use Test::Differences;
use Test::Partner2::Simple;

use qbit;

run_tests(
    \&main_test,
    application_package => 'Cron',
    init                => ['auto_stop'],
);

sub main_test {
    my ($app) = @_;

    require Partner2::Juggler::API;
    my %result;
    my $curdate;
    mock_subs(
        {
            'Cron::send_event' => sub {
                my ($self, %event) = @_;
                push @{$result{$curdate}{send_event}}, {args => \%event,};
            },
            'Cron::Methods::System::INFOF' => sub {
                my (@args) = @_;
                push @{$result{$curdate}{log}}, \@args;
            },
            'Application::Model::AutoStop::check_soon_auto_stop' => sub {
                my ($self, %opts) = @_;
                push @{$result{$curdate}{args}}, \%opts;
                return ([1001, 1002], [2001, 2002, 2003]);
            },
        }
    );
    $app->set_option('stage', 'test');
    for my $date (('2021-08-06', '2021-08-07', '2021-08-08', '2021-08-09')) {
        $curdate = $date;
        mock_curdate($date . ' 12:00:00');
        $app->do('system', 'check_soon_auto_stop');
    }

    my $expected = get_test_data_and_update_if_needed('data.json', \%result);
    eq_or_diff(\%result, $expected, 'check');
}
