#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Utils::MonitoringUtils qw(send_to_graphite);
use Test::Partner2::Mock qw(mock_subs);
use Test::Partner2::Simple;
use Test::More;
use Exception;

use qbit;

run_tests(
    sub {
        my ($app) = @_;
        my @graphite_data;
        my $event;
        mock_subs(
            {
                'Application::Model::Queue::send_to_graphite' => sub {
                    my (%opts) = @_;
                    delete $opts{timestamp};
                    push(@graphite_data, \%opts);
                },
                'Partner2::Juggler::API::send' => sub {
                    my ($self, %opts) = @_;
                    $event = \%opts;
                },
                'Cron::Methods::System::WARN' => sub {
                    fail 'warn is called';
                },
                'Cron::Methods::System::ERROR' => sub {
                    fail 'error is calles';
                  }
            },
        );

        subtest 'empty_queue' => sub {
            try {
                $app->do('system', 'check_stuck_tasks');
                pass('empty_queue passed');
            }
            catch {
                fail('empty_queue failed');
            };

        };
        subtest 'task_with_success_with_notify' => sub {
            $app->queue->add(
                method_name => 'update_mobile_app_status',
                params      => {app_id => 1, active => 1},
            );
            my $id = $app->queue->grab_next_task()->{id};
            $app->queue->do_action($id, 'finish_with_success');

            try {
                $app->do('system', 'check_stuck_tasks');
                pass('task_with_success_with_notify passed');
            }
            catch {
                fail('task_with_success_with_notify failed');
            };
            $app->partner_db->queue->delete($id);

        };
        subtest 'task_with_error_with_notify' => sub {
            $app->queue->add(
                method_name => 'update_mobile_app_status',
                params      => {app_id => 1, active => 1},
            );
            my $id = $app->queue->grab_next_task()->{id};
            $app->queue->do_action($id, 'finish_with_error', exception => Exception->new());

            try {
                $app->do('system', 'check_stuck_tasks');
                fail('task_with_error_with_notify');
            }
            catch {
                pass('task_with_error_with_notify');
            };
            $app->partner_db->queue->delete($id);

        };
        subtest 'task_with_success_without_notify' => sub {
            $app->queue->add(
                method_name => 'update_in_bk',
                params      => {page_ids => [1],},

            );
            my $id = $app->queue->grab_next_task()->{id};
            $app->queue->do_action($id, 'finish_with_success');

            try {
                $app->do('system', 'check_stuck_tasks');
                pass('task_with_success_without_notify passed');
            }
            catch {
                fail('task_with_success_without_notify failed');
            };
            $app->partner_db->queue->delete($id);

        };
        subtest 'task_with_error_without_notify' => sub {
            $app->queue->add(
                method_name => 'update_in_bk',
                params      => {page_ids => [1],},

            );
            my $id = $app->queue->grab_next_task()->{id};
            $app->queue->do_action($id, 'finish_with_error', exception => Exception->new());

            try {
                $app->do('system', 'check_stuck_tasks');
                pass('task_with_error_without_notify passed');
            }
            catch {
                fail('task_with_error_without_notify failed');
            };
            $app->partner_db->queue->delete($id);

        };
    },
    application_package => 'Cron',
    init                => [qw(queue)],
);
