#!/usr/bin/perl -w

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my @res = ();
        mock_subs(
            {
                'QBit::Cron::get_lock'              => sub {TRUE},
                'QBit::Application::Model::DB::_do' => sub {
                    push(@res, $_[1]);
                },
            }
        );

        $app->do('system', 'do_optimize_for_clickhouse_tables');

        cmp_deeply(\@res, ['OPTIMIZE TABLE `statistics`', 'OPTIMIZE TABLE `statistics_additional_income`'], 'SQL',);

    },
    application_package  => 'Cron',
    dont_create_database => TRUE,
);
