#!/usr/bin/perl

use Test::Partner2::Simple;
use Test::More;
use Test::Differences;

use qbit;

use Test::Partner2::Mock qw(
  mock_subs
  );

run_tests(
    sub {
        my ($app) = @_;

        my $DATA = {
            _get_all => [
                {
                    id   => 1,
                    time => 700,
                    info => q[ /* {"login":"","system":"rosetta"} */ select sleep(700)],
                },
                {
                    id   => 2,
                    time => 70,
                    info => q[ /* {"login":"","system":"rosetta"} */ select sleep(70)],
                },
                {
                    id   => 3,
                    time => 800,
                    info => q[ /* {"login":"","system":"restapi"} */ select sleep(800)],
                },
                {
                    id   => 4,
                    time => 80,
                    info => q[ /* {"login":"","system":"restapi"} */ select sleep(80)],
                },
                {
                    id   => 5,
                    time => 900,
                    info => q[ /* {"login":"","system":"webinterface"} */ select sleep(900)],
                },
                {
                    id   => 6,
                    time => 90,
                    info => q[ /* {"login":"","system":"webinterface"} */ select sleep(90)],
                },
                {
                    id   => 7,
                    time => 10000,
                    info => q[ select sleep(10000)],
                },
                {
                    id   => 8,
                    time => 10,
                    info => q[ /* {"login":"10 sec","system":"cron"} */ RENAME TABLE `all_pages_new` TO `all_pages`],
                },
                {
                    id   => 9,
                    time => 40,
                    info => q[ /* {"login":"40 sec","system":"cron"} */ RENAME TABLE `all_pages_new` TO `all_pages`],
                },
                {
                    id   => 10,
                    time => 150,
                    info => q[ /* {"login":"","system":"cron"} */ select sleep(150)],
                },
                {
                    id   => 11,
                    time => 950,
                    info => q[ /* {"login":"","system":"cron"} */ select sleep(150)],
                },
            ],
            _do => [9, 1, 3, 5, 7, 11,],
        };

        my $count = 0;
        mock_subs(
            {
                'QBit::Application::Model::DB::_get_all' => sub {
                    my ($self, $query) = @_;

                    if ($query =~ /information_schema\.processlist/) {
                        $count++;

                        my $data = $DATA->{'_get_all'};

                        return $count < 3 ? $data : [splice(@$data, 0, @$data - 1)];
                    } else {
                        return $Test::Partner2::Mock::original_subs->{'QBit::Application::Model::DB::_get_all'}->(@_);
                    }
                },
                'QBit::Application::Model::DB::_do' => sub {
                    my ($self, $query, $id) = @_;

                    if ($query =~ /KILL/) {
                        my $expected_id = shift(@{$DATA->{'_do'}});

                        is($id, $expected_id, "Kill id: $expected_id");
                    } else {
                        $Test::Partner2::Mock::original_subs->{'QBit::Application::Model::DB::_do'}->(@_);
                    }
                },
            }
        );

        $app->do('system', 'kill_long_db_queries');
        eq_or_diff $DATA->{'_do'}, [], 'No more ids to kill';
    },
    application_package => 'Cron',
);
