#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Partner2::Simple;
use Test::Partner2::Mock qw(
  mock_juggler
  mock_subs
  );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        #local $ENV{'TAP_VERSION'} = 0;

        mock_app($app);

        @ARGV = ('system', 'run_qbit_validator_checks_1', '--accessors=indoor,indoor_block');

        $app->do();
    },
    application_package => 'Cron',
);

sub mock_app {
    my ($app) = @_;

    mock_juggler($app);
    mock_subs(
        {
            'Cron::Methods::System::ERROR' => sub {fail($_[0]);}
        }
    );
}
