#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Data::Rmap qw(rmap_hash);
use Test::More;
use Test::Differences;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(mock_curdate get_test_data_and_update_if_needed);

use PiConstants qw($IS_PRECISE);

use qbit;

my @fields = qw(
  completed_percent
  error_data
  id
  log
  method_type
  method_name
  group_id
  multistate
  multistate_name
  params
  result
  user_id
  add_dt
  start_dt
  end_dt
  tries
  grabbed_by
  grabbed_at
  grabbed_until
  );

run_tests(
    sub {
        my ($app) = @_;

        my @got_data;
        mock_log(\@got_data);
        mock_method($app, \@got_data);

        $app->set_option(hostname => 'test.localhost.yandex-team.ru');

        mock_curdate('2018-02-10 15:00:00');

        $app->queue->add(
            method_name => 'update_mobile_app_status',
            params      => {app_id => 1, active => 1},
            # group_id    => 1,
        );

        push @got_data, {add_1 => $app->queue->get_all(fields => \@fields)};

        set_request_return_500();
        $app->do('system', 'start_task_1');

        push @got_data, {need_restart_1 => $app->queue->get_all(fields => \@fields)};

        $app->queue->add(
            method_name => 'update_mobile_app_status',
            params      => {app_id => 2, active => 1},
            # group_id    => 2,
        );

        push @got_data, {add_2 => $app->queue->get_all(fields => \@fields)};

        mock_curdate('2018-02-10 16:00:00');

        $app->do('system', 'restart_lost_tasks');

        set_request_return_ok();
        $app->do('system', 'start_task_1');

        push @got_data, {done_all => $app->queue->get_all(fields => \@fields)};

        my $expected = get_test_data_and_update_if_needed('data.json', \@got_data);
        if ($IS_PRECISE) {
            my $fix_data_sub = sub {
                my ($el) = @_;
                my @fields_to_num =
                  qw(current_user block_id id is_deleted multistate page_id page_multistate tries user_id);
                map {$el->{$_} += 0}
                  grep {defined $el->{$_}} @fields_to_num;
                foreach my $key (qw(result)) {
                    if (defined $el->{$key}) {
                        foreach my $subkey (@fields_to_num) {
                            $el->{$key} =~ s/("$subkey":)"(\d+)"/$1$2/g;
                        }
                    }
                }
                return $el;
            };
            rmap_hash {$fix_data_sub->($_)} @got_data;
            rmap_hash {$fix_data_sub->($_)} @$expected;
        }
        eq_or_diff(from_json(to_json(\@got_data)), $expected, 'compare', {context => 10});

    },
    application_package => 'Cron',
    init                => [qw(users)],
);

sub set_request_return_ok {
    no warnings 'redefine';
    no strict 'refs';
    require LWP::UserAgent;
    *{'LWP::UserAgent::request'} = sub {
        my $r = HTTP::Response->new(200);
        $r->request(HTTP::Request->new());
        $r->content('{"data":{"AdfoxInternal":{"updateMobileAppStatus":true}}}');
        return $r;
    };
}

sub set_request_return_500 {
    no warnings 'redefine';
    no strict 'refs';
    require LWP::UserAgent;
    *{'LWP::UserAgent::request'} = sub {
        my $r = HTTP::Response->new(500);
        $r->request(HTTP::Request->new());
        return $r;
    };
}

sub mock_log {
    my ($data) = @_;
    no warnings 'redefine';
    no strict 'refs';
    require QBit::Application::Model::API::HTTP;
    *{'QBit::Application::Model::API::HTTP::INFO'} = sub { };
    require Application::Model::Queue;
    *{'Application::Model::Queue::ERROR'} = sub {
        push @$data, {ERROR => $_[0]->message};
    };
}

sub mock_method {
    my ($app, $got_data) = @_;

    require Application::Model::Queue::Methods;

    my $orig = \&Application::Model::Queue::Methods::update_mobile_app_status;
    no warnings 'redefine';
    no strict 'refs';
    *{'Application::Model::Queue::Methods::update_mobile_app_status'} = sub {
        my ($self, %args) = @_;
        push @$got_data, {after_start => $app->queue->get_all(fields => \@fields, filter => {id => $args{task_id}})};
        $orig->($self, %args);
    };

    my $orig2 = \&Application::Model::Queue::get_worker_id;
    *{'Application::Model::Queue::get_worker_id'} = sub {
        my ($self) = @_;

        my $wid = $orig2->($self);
        $wid =~ s/\:\d+$/:10000/;
        return $wid;
    };
}
