#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        is(scalar(@{$app->partner_db->brands->get_all()}), 9, 'brands before update');

        set_articles_for_all_blocks($app);

        my $response = {
            't_brand' => {
                'columns' => [
                    't_brand.bid',    't_brand.name',    't_brand.ename', 't_brand.note',
                    't_brand.status', 't_brand.file_id', 't_brand.hidden'
                ],
                'result' => [
                    [
                        '1702', 'LONDA', 'LONDA',
                        "принадлежит PROCTER & GAMBLE с 2004года - 10.2016, с 10.2016",
                        'A', '10032', '0'
                    ]
                ]
            },
            't_article' => {
                'columns' => [
                    't_article.sid',   't_article.grid', 't_article.lev',    't_article.name',
                    't_article.ename', 't_article.note', 't_article.status', 't_article.file_id',
                    't_article.hidden'
                ],
                'result' => [
                    [
                        '226', '67', '3',
                        "УПАКОВОЧНЫЕ МАТЕРИАЛЫ",
                        'PACKAGING MATERIALS',
                        undef, 'A', '1590', '0'
                    ]
                ]
            },
        };

        {
            no strict 'refs';
            no warnings 'redefine';

            *{'QBit::Application::Model::API::XMLRPC::call'} = sub {
                my ($self, $method, $arr_table, $filter) = @_;

                return [$response->{$arr_table->[0]}];
            };
        }

        $app->do('tns_dict', 'update_tns_dict');

        cmp_deeply(
            $app->partner_db->tns_dict_brand->get_all(),
            [
                {
                    'bid'     => '1702',
                    'file_id' => '10032',
                    'hidden'  => '0',
                    'name'    => 'LONDA',
                    'note'    => "принадлежит PROCTER & GAMBLE с 2004года - 10.2016, с 10.2016",
                    'status'  => 'A'
                }
            ],
            'tns_dict_brand'
        );

        is(scalar(@{$app->partner_db->brands->get_all()}), 0, 'brands after update');

        cmp_deeply(
            $app->partner_db->tns_dict_article->get_all(),
            [
                {
                    'file_id' => '1590',
                    'grid'    => '67',
                    'hidden'  => '0',
                    'lev'     => '3',
                    'name'    => "УПАКОВОЧНЫЕ МАТЕРИАЛЫ",
                    'note'    => undef,
                    'sid'     => '226',
                    'status'  => 'A'
                }
            ],
            'tns_dict_article'
        );

        my @block_models = get_blocks_with_articles($app);

        foreach my $model (@block_models) {
            my @data = grep {$_->{'articles'} ne '[]'} @{$model->get_all(fields => [qw(articles)])};

            ok(!@data, $model->accessor . ' - remove articles');
        }
    },
    application_package => 'Cron',
    init                => ['api_balance'],
    locale              => 'en',
);

sub get_blocks_with_articles {
    my ($app) = @_;

    my %models_in_java = map {$_ => 1} qw(mobile_app_rtb internal_mobile_app_rtb);

    return map {$app->$_}
      grep {$app->$_->DOES('Application::Model::Role::Has::Articles') && !$models_in_java{$_}}
      @{$app->product_manager->get_block_model_names()};
}

sub set_articles_for_all_blocks {
    my ($app) = @_;

    $app->articles->partner_db_table->edit($app->partner_db->filter(\TRUE), {article_sid => 40});
}
