use strict;
use warnings FATAL => 'all';

require Cron::Methods::UpdateBKAsync;

use Test::More;
use Test::Deep qw(cmp_bag cmp_deeply);

my @page_ids = qw(
  6588
  30487
  77280
  170388
  187000
  188967
  192311
  212336
  213160
  217666
  218768
  224131
  228848
  234211
  234501
  237661
  241753
  248122
  248605
  250594
  250595
  );

foreach my $instances_count (1 .. 20) {

    my %pages_in_instances;

    foreach my $instance_number (1 .. $instances_count) {

        my @pages_for_this_instance;

        foreach my $page_id (@page_ids) {
            if (
                Cron::Methods::UpdateBKAsync::_is_instance_for_page(
                    page_id         => $page_id,
                    instances_count => $instances_count,
                    instance_number => $instance_number,
                )
               )
            {
                push @pages_for_this_instance, $page_id;
                $pages_in_instances{$page_id}++;
            }
        }

    }

    cmp_bag([keys(%pages_in_instances)],
        \@page_ids, "With instances_count = $instances_count all pages are distributes on instances");
    cmp_deeply(
        \%pages_in_instances,
        {map {$_ => 1} @page_ids},
        "With instances_count = $instances_count every page is distribute only to one instance"
    );
}

done_testing();
