#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use qbit;

use Data::Rmap qw(rmap_hash);
use Test::Partner2::Simple;
use Test::More;
use Test::Differences qw (eq_or_diff);
use Test::Partner2::Mock;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

run_tests(
    sub {
        my ($cron) = @_;

        mock_bk($cron);

        my @got_data;
        $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
            my ($data, $opts) = @_;
            delete $data->{'0'}->{'Slots'};
            push @got_data, {data => $data, opts => $opts};
            return 1;
        };

        mock_curdate('2018-12-01 10:00:00');

        $cron->partner_db->heavy_pages->add({page_id => 41443});

        push @got_data, 'light';
        @ARGV = ('update_bk_async', 'async_logbrocker_light_pages_in_bk', '--only_page_ids=40,400,801,802,41443,43569');
        $cron->do();

        push @got_data, 'heavy';
        @ARGV = ('update_bk_async', 'async_logbrocker_heavy_pages_in_bk', '--only_page_ids=40,400,801,802,41443,43569');
        $cron->do();

        push @got_data, 'again';
        @ARGV = ('update_bk_async', 'async_logbrocker_light_pages_in_bk', '--only_page_ids=40,400,801,802,41443,43569');
        $cron->do();
        @ARGV = ('update_bk_async', 'async_logbrocker_heavy_pages_in_bk', '--only_page_ids=40,400,801,802,41443,43569');
        $cron->do();

        my $has_data = get_test_data_and_update_if_needed('bk_data.json', \@got_data, blessed => 1);
        eq_or_diff(from_json(to_json(\@got_data, blessed => 1)), $has_data, 'compare data', {context => 10});
    },
    do_not_die_on_fail  => 1,
    application_package => 'Cron'
);

package SOAP::Data;

sub TO_JSON {
    my ($value) = @_;
    my %tmp = %$value;
    return \%tmp;
}
