#!/usr/bin/perl -w

use Test::More;
use Test::Differences qw (eq_or_diff);
use Test::Partner2::Mock qw(mock_curdate);

use qbit;

use Test::Partner2::Simple;

my $CUR_DATETIME = '2022-02-18 12:07:43';

run_tests(
    sub {
        my ($cron) = @_;

        mock_curdate($CUR_DATETIME);

        my $curdate_min_1w = date_sub($CUR_DATETIME, week  => 1, iformat => 'db_time', oformat => 'db_time');
        my $curdate_min_2m = date_sub($CUR_DATETIME, month => 2, iformat => 'db_time', oformat => 'db_time');

        my $pages_to_send = [
            {
                # отработал 1 неделю назад
                page_id      => 1,
                model        => 'context_on_site_campaign',
                worker       => 'fake_worker_1',
                update_time  => $curdate_min_1w,
                start_update => $curdate_min_1w,
                processed    => 1,
                stop_update  => $curdate_min_1w,
            },
            {
                # НЕ отработал 2 месяца назад
                page_id      => 2,
                model        => 'context_on_site_campaign',
                worker       => undef,
                update_time  => $curdate_min_2m,
                start_update => undef,
                processed    => 0,
                stop_update  => undef,
            },
            {
                # отработал 2 месяца назад
                page_id      => 3,
                model        => 'context_on_site_campaign',
                worker       => 'fake_worker_3',
                update_time  => $curdate_min_2m,
                start_update => $curdate_min_2m,
                processed    => 1,
                stop_update  => $curdate_min_2m,
            },
        ];

        $cron->partner_db->need_update_pages->add_multi($pages_to_send);

        $cron->do('update_bk_async', 'clean_need_update_pages_table');

        my $pages_after_cron = $cron->partner_db->need_update_pages->get_all(
            fields   => [qw(page_id model worker update_time start_update processed stop_update)],
            order_by => ['page_id']
        );

        # Крон должен удалить запись для page_id = 3;
        pop(@$pages_to_send);

        eq_or_diff($pages_after_cron, $pages_to_send, 'check result');
    },
    fill_databases      => FALSE,
    application_package => 'Cron'
);
