#!/usr/bin/perl -w

use Test::More;
use Test::Differences qw (eq_or_diff);
use Test::Partner2::Mock qw(mock_curdate);

use qbit;

use Test::Partner2::Simple;

my $CUR_DATETIME = '2022-02-18 12:07:43';

run_tests(
    sub {
        my ($cron) = @_;

        mock_curdate($CUR_DATETIME);

        my $curdate_min_2h = date_sub($CUR_DATETIME, hour => 2, iformat => 'db_time', oformat => 'db_time');
        my $curdate_min_4h = date_sub($CUR_DATETIME, hour => 4, iformat => 'db_time', oformat => 'db_time');

        my $pages_to_send = [
            {
                # отработал 2 часа назад успешно
                page_id      => 1,
                model        => 'context_on_site_campaign',
                worker       => 'fake_worker_1',
                update_time  => $curdate_min_2h,
                start_update => $curdate_min_2h,
                processed    => 1,
            },
            {
                # отработал 2 часа назад НЕ успешно
                page_id      => 2,
                model        => 'context_on_site_campaign',
                worker       => undef,
                update_time  => $curdate_min_2h,
                start_update => undef,
                processed    => 0,
            },
            {
                # потерялся 2 часа назад
                page_id      => 3,
                model        => 'context_on_site_campaign',
                worker       => 'fake_worker_3',
                update_time  => $curdate_min_2h,
                start_update => $curdate_min_2h,
                processed    => 0,
            },
            {
                # отработал 4 часа назад успешно
                page_id      => 4,
                model        => 'context_on_site_campaign',
                worker       => 'fake_worker_4',
                update_time  => $curdate_min_4h,
                start_update => $curdate_min_4h,
                processed    => 1,
            },
            {
                # отработал 4 часа назад НЕ успешно
                page_id      => 5,
                model        => 'context_on_site_campaign',
                worker       => undef,
                update_time  => $curdate_min_4h,
                start_update => undef,
                processed    => 0,
            },
            {
                # потерялся 4 часа назад
                page_id      => 6,
                model        => 'context_on_site_campaign',
                worker       => 'fake_worker_6',
                update_time  => $curdate_min_4h,
                start_update => $curdate_min_4h,
                processed    => 0,
            }
        ];

        $cron->partner_db->need_update_pages->add_multi($pages_to_send);

        $cron->do('update_bk_async', 'grab_lost_updating_pages');

        my $pages_after_cron = $cron->partner_db->need_update_pages->get_all(
            fields   => [qw(page_id model worker update_time start_update processed)],
            order_by => ['page_id']
        );

        # Крон должен скинуть worker и start_update для page_id = 6;
        $pages_to_send->[-1]{'worker'}       = undef;
        $pages_to_send->[-1]{'start_update'} = undef;

        eq_or_diff($pages_after_cron, $pages_to_send, 'check result');
    },
    fill_databases      => FALSE,
    application_package => 'Cron'
);
