#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Partner2::Simple;
use Test::More tests => 3;
use Test::Differences qw (eq_or_diff);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

run_tests(
    sub {
        my ($cron) = @_;

        my %got;
        no warnings 'redefine';
        no strict 'refs';
        *{'Cron::Methods::send_to_graphite'} = sub {
            my %data = @_;
            $got{$data{path}} = \%data;
        };
        $cron->do('update_bk_async', 'check_update_in_bk');
        $cron->do('update_bk_async', 'check_send_in_bk');

        my $has = get_test_data_and_update_if_needed('data.json', \%got);
        eq_or_diff(\%got, $has, 'compare data');
    },
    do_not_die_on_fail  => 1,
    application_package => 'Cron'
);
