#!/usr/bin/perl -w

use Test::More;
use Test::Differences qw (eq_or_diff);
use Test::Partner2::Mock qw(mock_curdate mock_subs);

use qbit;

use Test::Partner2::Simple;

my $CUR_DATETIME = '2022-02-18 12:07:43';
my $UPDATE_TIME = date_sub($CUR_DATETIME, hour => 1, iformat => 'db_time', oformat => 'db_time');

my $INFOF    = [];
my $PAGE_IDS = [
    1,    # ok
    2,    # not ok
    3     # updated
];

$ENV{'LAZY_LOAD'} = FALSE;

run_tests(
    sub {
        my ($cron) = @_;

        mock_curdate($CUR_DATETIME);

        $$ = 100500;

        my $curdate_id = trdate('db_time', 'date_time_only_numbers', $CUR_DATETIME);

        my $fqdn = 'fqdn';

        $cron->set_option('hostname', $fqdn);

        my $worker = sprintf('%s_%d_%d', $fqdn, $$, $curdate_id);

        mock_subs(
            {
                'Application::Model::Page::update_in_bk' => sub {
                    my ($self, $opts) = @_;

                    if ($opts->{'page_id'} == 2) {
                        throw Exception 'Fail';
                    }
                },
                'Application::Model::PageMinimal::update_in_bk' => sub {
                    my ($self, $opts) = @_;

                    if ($opts->{'page_id'} == 2) {
                        throw Exception 'Fail';
                    }
                },
                'QBit::Application::Model::DBManager::get_all' => sub {
                    my ($self, %opts) = @_;

                    if ($self->isa('Application::Model::Page') || $self->isa('Application::Model::PageMinimal')) {
                        my @result = ();
                        foreach my $page_id (@{$opts{'filter'}->{'page_id'}}) {
                            push(
                                @result,
                                {
                                    page_id     => $page_id,
                                    update_time => $page_id == 3 ? $CUR_DATETIME : $UPDATE_TIME,
                                }
                            );
                        }
                        return \@result;
                    }

                    return [];
                },
                'Cron::Methods::UpdateBKAsync::INFOF' => sub {
                    my ($msg, @args) = @_;

                    push(@$INFOF, sprintf($msg, @args));
                },
            }
        );

        $cron->do('update_bk_async', 'send_pages_to_bk_1');

        eq_or_diff($INFOF, ['Pages not found'], 'Pages not found');

        my $page_accessors = $cron->product_manager->get_page_model_accessors();

        foreach my $page_accessor (@$page_accessors) {
            $INFOF = [];

            $cron->partner_db->need_update_pages->truncate();

            $cron->partner_db->need_update_pages->add_multi(
                [map {{page_id => $_, model => $page_accessor, update_time => $CUR_DATETIME}} @$PAGE_IDS]);

            $cron->do('update_bk_async', 'send_pages_to_bk_1');

            eq_or_diff(
                $INFOF,
                [
                    'found 3 pages to send to BK',
                    "Sending page=$PAGE_IDS->[0] ($page_accessor)",
                    "Sending page=$PAGE_IDS->[1] ($page_accessor)",
                    "Sending page=$PAGE_IDS->[2] ($page_accessor)",
                    "Page $PAGE_IDS->[2] ($page_accessor) was updated",
                    'Sent 1 pages',
                    'Failed 2 pages'
                ],
                "check infof: $page_accessor"
            );

            my $after_cron = $cron->partner_db->need_update_pages->get_all();

            eq_or_diff(
                $after_cron,
                [
                    {
                        'id'           => 1,
                        'model'        => $page_accessor,
                        'page_id'      => 1,
                        'processed'    => 1,
                        'start_update' => $CUR_DATETIME,
                        'stop_update'  => $CUR_DATETIME,
                        'update_time'  => $CUR_DATETIME,
                        'worker'       => $worker
                    },
                    {
                        'id'           => 2,
                        'model'        => $page_accessor,
                        'page_id'      => 2,
                        'processed'    => 0,
                        'start_update' => undef,
                        'stop_update'  => undef,
                        'update_time'  => $CUR_DATETIME,
                        'worker'       => undef
                    },
                    {
                        'id'           => 3,
                        'model'        => $page_accessor,
                        'page_id'      => 3,
                        'processed'    => 0,
                        'start_update' => undef,
                        'stop_update'  => undef,
                        'update_time'  => $CUR_DATETIME,
                        'worker'       => undef
                    }
                ],
                "check db: $page_accessor"
            );
        }
    },
    fill_databases      => FALSE,
    application_package => 'Cron'
);
