#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_curdate mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::Differences;
use Utils::MonitoringUtils;

use qbit;

my %params =
  (fields => ["accessor", "create_date", "id", "multistate", "multistate_name", "notification_id", "opts", "user_id"]);

run_tests(
    sub {
        my ($app) = @_;

        my @graphite_data;
        mock_subs(
            {
                'Utils::MonitoringUtils::send_to_graphite' => sub {
                    my (%opts) = @_;
                    push(@graphite_data, \%opts);
                },
            }
        );

        my $tmp = $app->add_all_tmp_rights();
        mock_curdate('2019-01-01 11:10:00');

        my $custom_id = $app->notification->add(
            type      => 'custom',
            view_type => 'default',
            caption   => {
                ru => 'заголовок user',
                en => 'caption user',
            },
            message => {
                ru => 'message user',
                en => 'сообщение user',
            },
            ttl        => 10,
            icon_id    => 'default',
            logins     => ['mocked-yan-partner', 'mocked-mobile-app-partner', 'mocked-mobile-app-partner'],
            short_name => 'message_user',
        );

        my $fns_notification_id = $app->notification->get_all(filter => {short_name => 'fns_message'})->[0]->{id};

        my @result;
        $app->user_notifications->add(
            notification_id => 1,
            user_id         => 1009,
        );
        $app->user_notifications->add(
            notification_id => 2,
            user_id         => 1009,
        );
        $app->user_notifications->add(
            notification_id => $custom_id,
            user_id         => 1009,
        );
        $app->user_notifications->add(
            notification_id => $fns_notification_id,
            user_id         => 1009,
        );

        $app->do('user_notifications', 'cleanup_expired_auto');
        push @result, 'after create', $app->user_notifications->get_all(%params);

        mock_curdate('2019-04-02 11:10:01');

        $app->do('user_notifications', 'cleanup_expired_auto');
        push @result, 'after expire',  $app->user_notifications->get_all(%params);
        push @result, 'graphite_data', \@graphite_data;

        my $expected = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $expected, 'checks');
    },
    application_package => 'Cron',
    mocks               => {mock_send_to_graphite => FALSE},
);
