#!/usr/bin/perl -w
use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_curdate mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::Differences;

my %params =
  (fields => ["accessor", "create_date", "id", "multistate", "multistate_name", "notification_id", "opts", "user_id"]);

run_tests(
    sub {
        my ($app) = @_;

        my @graphite_data;
        mock_subs(
            {
                'Utils::MonitoringUtils::send_to_graphite' => sub {
                    my (%opts) = @_;
                    delete $opts{timestamp};
                    push(@graphite_data, \%opts);
                },
            }
        );

        my $tmp = $app->add_all_tmp_rights();
        mock_curdate('2019-06-27 11:10:00');

        my @result;
        my $id = $app->notification->add(
            type      => 'custom',
            view_type => 'default',
            caption   => {
                ru => 'заголовок user',
                en => 'caption user',
            },
            message => {
                ru => 'message user',
                en => 'сообщение user',
            },
            ttl        => 10,
            icon_id    => 'default',
            logins     => ['mocked-yan-partner', 'mocked-mobile-app-partner', 'mocked-mobile-app-partner'],
            short_name => 'message_user',
        );

        $app->do('user_notifications', 'generate_logins');
        push @result, $app->user_notifications->get_all(%params);

        $app->notification->do_action($id, 'start');

        $app->do('user_notifications', 'generate_logins');
        push @result, $app->user_notifications->get_all(%params);

        $app->notification->do_action($id, 'edit',
            logins => ['mocked-video-partner', 'mocked-video-partner', 'mocked-mobile-app-partner']);

        $app->do('user_notifications', 'generate_logins');
        push @result, $app->user_notifications->get_all(%params);

        mock_curdate('2019-06-27 11:15:00');
        $app->do('user_notifications', 'monitor_create');

        push @result, 'graphite_data', \@graphite_data;

        my $expected = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $expected, 'checks');
    },
    application_package => 'Cron',
    mocks               => {mock_send_to_graphite => FALSE},
);
