#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_curdate mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::Differences;
use Utils::MonitoringUtils;

use qbit;

my %params =
  (fields => ["accessor", "create_date", "id", "multistate", "multistate_name", "notification_id", "opts", "user_id"]);

run_tests(
    sub {
        my ($app) = @_;

        my @graphite_data;
        mock_subs(
            {
                'Utils::MonitoringUtils::send_to_graphite' => sub {
                    my (%opts) = @_;
                    delete $opts{timestamp};
                    push(@graphite_data, \%opts);
                },
            }
        );

        my $tmp = $app->add_all_tmp_rights();
        mock_curdate('2019-01-01 11:10:00');

        my @result;
        $app->user_notifications->add(
            notification_id => 1,
            user_id         => 1009,
            custom_data     => {resource => 'resource'},
        );

        $app->user_notifications->add(
            notification_id => 2,
            user_id         => 1009,
            custom_data     => {resource => 'resource'},
        );

        mock_curdate('2019-01-01 11:15:00');
        $app->do('user_notifications', 'monitor_create');
        push @result, 'after create', $app->user_notifications->get_all(%params);

        push @result, 'graphite_data', \@graphite_data;

        my $expected = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $expected, 'checks');
    },
    application_package => 'Cron',
    mocks               => {mock_send_to_graphite => FALSE},
);
