#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs restore_subs mock_curdate);

use Test::Differences;

use qbit;

my $mocked_date = '2019-06-27 11:10:00';

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate($mocked_date);

        my $do_action_call_n     = 0;
        my $query_get_all_call_n = 0;

        my $add_multi = \&QBit::Application::Model::DB::mysql::Table::add_multi;
        my $get_all   = \&QBit::Application::Model::DB::Query::get_all;

        my $subs2mock = {
            'Application::Model::Notification::get_all' => sub {
                my ($self, %opts) = @_;
                return [{id => 111, short_name => 'test_note'}];
            },
            'Application::Model::Notification::do_action' => sub {
                my ($self, $id, $action) = @_;
                if (0 eq $do_action_call_n) {
                    eq_or_diff($action, 'start_update', 'start_update called');
                } elsif (1 eq $do_action_call_n) {
                    eq_or_diff($action, 'stop_update', 'stop_update called');
                }
                $do_action_call_n++;
            },
            'QBit::Application::Model::DB::mysql::Query::get_all' => sub {
                my ($self, %opts) = @_;

                if (caller eq 'Cron::Methods::UserNotifications') {
                    # update started
                    if (1 eq $do_action_call_n) {
                        # user_notifications to delete
                        if (0 eq $query_get_all_call_n) {
                            $query_get_all_call_n++;
                            return [{id => 1, notification_id => 111, user_id => 222},];
                        }
                        # user_notifications to add
                        elsif (1 eq $query_get_all_call_n) {
                            return [{uids_id => 333}, {uids_id => 334}];
                        }
                    }
                }
                goto &$get_all;
            },
            'QBit::Application::Model::DB::mysql::Table::add_multi' => sub {
                my ($self, $list) = @_;

                if (caller eq 'Cron::Methods::UserNotifications') {
                    my $expected = [
                        {
                            'create_date'     => $mocked_date,
                            'notification_id' => 111,
                            'opts'            => '{}',
                            'user_id'         => 333
                        },
                        {
                            'create_date'     => $mocked_date,
                            'notification_id' => 111,
                            'opts'            => '{}',
                            'user_id'         => 334
                        }
                    ];
                    eq_or_diff($list, $expected, 'adding user_notifications');
                    return 2;
                }
                goto &$add_multi;
            },
            'QBit::Application::Model::DB::mysql::Table::delete' => sub {
                my ($self, $filter) = @_;

                my $expected = ['AND', [['id', 'IN', \[1]]]];
                eq_or_diff($filter->expression, $expected, 'deleting user_notifications');
                return 1;
            },
        };

        mock_subs($subs2mock);
        $app->do('user_notifications', 'generate_logins');

        restore_subs([keys %$subs2mock]);

        $subs2mock = {
            'QBit::Application::Model::DB::mysql::Query::get_all' => sub {
                my ($self, %opts) = @_;

                if (caller eq 'Cron::Methods::UserNotifications') {
                    return [{id => 1,}, {id => 2,}, {id => 5,},];
                }
                goto &$get_all;
            },
            'QBit::Application::Model::DB::mysql::Table::delete' => sub {
                my ($self, $filter) = @_;

                my $expected = ['AND', [['notification_id', 'IN', \[1, 2, 5]], ['multistate', 'IN', \['0']]]];
                eq_or_diff($filter->expression, $expected, 'deleting user_notifications');
                return 3;
            },
        };

        mock_subs($subs2mock);
        $app->do('user_notifications', 'cleanup_expired');

        restore_subs([keys %$subs2mock]);

    },
    application_package  => 'Cron',
    dont_create_database => 1,
);
