#!/usr/bin/perl -w

use lib::abs;

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::Differences qw(eq_or_diff);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my @yt_rewrite_table_on_cluster_params;

        $app->$_ for (qw(api_yt));
        mock_subs(
            {
                'QBit::Application::Model::API::Yandex::YT::rewrite_table_on_cluster' => sub {
                    my ($self, %params) = @_;
                    push @yt_rewrite_table_on_cluster_params, \%params;
                },
            }
        );

        foreach my $cron (qw(export_domains)) {
            $app->do('webmaster', $cron);

            my $expected = get_test_data_and_update_if_needed('yt_rewrite_table_on_cluster_params.json',
                \@yt_rewrite_table_on_cluster_params);
            eq_or_diff(\@yt_rewrite_table_on_cluster_params, $expected, 'YT rewrite_table_on_cluster_params');
        }
    },
    application_package => 'Cron',
);
