#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Differences qw(eq_or_diff);
use Test::More;

use Test::Partner2::Mock qw(mock_subs restore_subs);
use qbit;

run_tests(

    sub {
        my ($app) = @_;

        my @check_acessors = ();
        {
            my $page_accessors = $app->product_manager->get_page_model_accessors();
            foreach my $model (sort @$page_accessors) {
                my $has_protected = $app->$model->get_multistate_by_name('protected');
                my $has_readonly  = $app->$model->get_multistate_by_name('read_only');

                next if $model =~ /^ssp_/ || (!$has_protected && !$has_readonly);
                push @check_acessors, $model;
            }
        }

        eq_or_diff(
            [sort @check_acessors],
            [
                sort qw(
                  context_on_site_campaign
                  internal_context_on_site_campaign

                  search_on_site_campaign
                  internal_search_on_site_campaign

                  mobile_app_settings
                  internal_mobile_app

                  video_an_site
                  indoor
                  outdoor

                  distribution_campaign
                  )
            ],
            "Check page models"
        );

        foreach my $set_params (FALSE, TRUE) {

            ### mock method call
            mock_subs(
                {
                    'QBit::Application::Model::API::Yandex::YT::select_from_any_replica' => sub {
                        my ($mock, %opts) = @_;
                        my @pages;
                        if ($opts{yql} =~ /PageID IN \(([^\)]+)\)/) {
                            @pages = split /\s*,\s*/, $1;
                        }

                        @pages = map to_json(
                            {PageID => $_, OptionsProtected => $set_params ? \1 : \0, ReadOnly => $set_params ? 1 : 0}
                          ),
                          @pages;

                        return join("\n", @pages);
                    },
                }
            );

            subtest sprintf('protected=%s', $set_params ? 'TRUE' : 'FALSE') => sub {
                note sprintf("Start %s protected", ($set_params ? 'is' : 'not'));

                ### run Cron
                $app->do('system', 'check_read_only_and_protected');

                my %campaigns = ();
                foreach my $model (sort @check_acessors) {
                    my $has_readonly = $app->$model->get_multistate_by_name('read_only');
                    my $has_testing  = $app->$model->get_multistate_by_name('testing');

                    ### get flags
                    my $data = $app->$model->get_all(
                        fields => [qw(page_id is_protected), $has_readonly ? 'is_read_only' : ()],
                        filter => {'multistate' => 'working' . ($has_testing ? ' or testing' : '')},
                    );
                    my $pages = $campaigns{$model} = {map {$_->{'page_id'} => $_} @$data};
                    next unless %$pages;

                    ## check flags
                    subtest "$model" => sub {
                        note sprintf('model = %s', $model);
                        foreach my $page_id (keys %$pages) {
                            is($pages->{$page_id}->{is_protected},
                                $set_params,
                                sprintf('%s: %d - %s protected', $model, $page_id, ($set_params ? 'is' : 'not')));
                            is($pages->{$page_id}->{is_read_only},
                                $set_params,
                                sprintf('%s: %d - %s read_only', $model, $page_id, ($set_params ? 'is' : 'not')))
                              if ($has_readonly);
                        }
                    };
                }
            };

            restore_subs(['QBit::Application::Model::API::Yandex::YT::select_from_any_replica']);
        }
    },
    application_package => 'Cron',
    init                => ['api_yt'],
);
