#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More;

use Test::Partner2::Fixture;
use Test::Partner2::Mock qw(mock_curdate);
use Test::Partner2::Simple;

use qbit;

my $mocked_dt    = '2020-04-16 11:10:00';
my $page_fixture = 'partner_context_page';

run_tests(
    sub {
        my ($app) = @_;

        my $self = Cron::Methods::UpdateBKAsync->new(app => $app);

        mock_curdate($mocked_dt);
        my $max_seconds_waiting4update = 60;
        my $update_time_not_ok = date_sub(curdate(), second => $max_seconds_waiting4update + 1, oformat => 'db_time');

        my $pages        = get_fixtures_hash($page_fixture);
        my $context_page = $pages->{$page_fixture};

        for my $accessor (q(context_on_site_campaign)) {
            my $model = $app->$accessor;
            my %opts  = (
                accessor          => $accessor,
                fields            => [$model->get_page_id_field_name()],
                update_time_limit => $max_seconds_waiting4update
            );

            $model->partner_db_table->edit(
                $context_page,
                {
                    multistate  => 1 + 16,                # need_update + working + balance_registered
                    update_time => $update_time_not_ok,
                    create_date => $mocked_dt,
                }
            );
            is_deeply($self->get_model_items_to_update(%opts),     [], 'get - no pages in need_update');
            is_deeply($self->check_model_items_update_time(%opts), [], 'check - no pages in need_update');

            $model->partner_db_table->edit(
                $context_page,
                {
                    multistate  => 2048 + 1,              # need_update + working
                    update_time => $update_time_not_ok,
                }
            );
            is_deeply($self->get_model_items_to_update(%opts), [], 'get - no pages in need_update+balance_registered');
            is_deeply($self->check_model_items_update_time(%opts),
                [], 'check - no pages in need_update+balance_registered');

            $model->partner_db_table->edit(
                $context_page,
                {
                    multistate  => 2048 + 1 + 16,         # need_update + working + balance_registered
                    update_time => $update_time_not_ok,
                }
            );
            is_deeply(
                $self->get_model_items_to_update(%opts),
                [
                    {
                        page_id     => $context_page->{page_id},
                        create_date => $mocked_dt,
                        update_time => $update_time_not_ok
                    }
                ],
                'get - one page in need_update+balance_registered'
            );
            is_deeply(
                $self->check_model_items_update_time(%opts),
                [
                    {
                        page_id     => $context_page->{page_id},
                        create_date => $mocked_dt,
                        update_time => $update_time_not_ok,
                        days_ago    => 0,
                    }
                ],
                'check - one page in need_update+balance_registered'
            );
        }

    },
    fill_databases      => 0,
    fixtures            => [$page_fixture],
    application_package => 'Cron',
);
